/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.common.util.FakePlayer;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.capability.ChampionCapability;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.config.ConfigEnums;
import top.theillusivec4.champions.common.config.ConfigLoot;
import top.theillusivec4.champions.common.rank.Rank;

public class ChampionLootModifier
extends LootModifier {
    public static final Codec<ChampionLootModifier> CODEC = RecordCodecBuilder.create(inst -> ChampionLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, ChampionLootModifier::new));
    private static final ThreadLocal<Boolean> IS_PROCESSING = ThreadLocal.withInitial(() -> false);

    public ChampionLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    @Nonnull
    public ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        if (entity == null) {
            return generatedLoot;
        }
        DamageSource damageSource = (DamageSource)context.m_78953_(LootContextParams.f_81457_);
        if (damageSource == null) {
            return generatedLoot;
        }
        if (!entity.m_9236_().m_46469_().m_46207_(GameRules.f_46135_) || !ChampionsConfig.fakeLoot && damageSource.m_7640_() instanceof FakePlayer) {
            return generatedLoot;
        }
        ChampionCapability.getCapability(entity).ifPresent(champion -> {
            List<ItemStack> loot;
            IChampion.Server serverChampion = champion.getServer();
            ServerLevel serverWorld = (ServerLevel)entity.m_9236_();
            if (ChampionsConfig.lootSource != ConfigEnums.LootSource.CONFIG) {
                LivingEntity livingEntity;
                LivingEntity attackingEntity;
                LootTable lootTable = serverWorld.m_7654_().m_129898_().m_79217_(new ResourceLocation("champions:champion_loot"));
                LootContext.Builder lootcontext$builder = new LootContext.Builder(serverWorld).m_230911_(entity.f_19853_.m_213780_()).m_78972_(LootContextParams.f_81455_, (Object)entity).m_78972_(LootContextParams.f_81460_, (Object)entity.m_20182_()).m_78972_(LootContextParams.f_81457_, (Object)damageSource).m_78984_(LootContextParams.f_81458_, (Object)damageSource.m_7639_()).m_78984_(LootContextParams.f_81459_, (Object)damageSource.m_7640_());
                if (entity instanceof LivingEntity && (attackingEntity = (livingEntity = (LivingEntity)entity).m_21232_()) instanceof Player) {
                    lootcontext$builder = lootcontext$builder.m_78972_(LootContextParams.f_81456_, (Object)((Player)attackingEntity)).m_78963_(((Player)attackingEntity).m_36336_());
                }
                lootTable.m_79131_(lootcontext$builder.m_78975_(LootContextParamSets.f_81415_), arg_0 -> ((ObjectArrayList)generatedLoot).add(arg_0));
            }
            if (ChampionsConfig.lootSource != ConfigEnums.LootSource.LOOT_TABLE && !(loot = ConfigLoot.getLootDrops(serverChampion.getRank().map(Rank::getTier).orElse(0))).isEmpty()) {
                generatedLoot.addAll(loot);
            }
        });
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

