/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.mixin;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tschipp.carryon.Constants;
import tschipp.carryon.client.render.CarryRenderHelper;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.scripting.CarryOnScript;

@Mixin(value={HumanoidModel.class})
public class HumanoidModelMixin {
    @Shadow
    public ModelPart f_102811_;
    @Shadow
    public ModelPart f_102812_;

    @Inject(at={@At(value="RETURN")}, method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"})
    private void onSetupAnimations(LivingEntity living, float f1, float f2, float f3, float f4, float f5, CallbackInfo ci) {
        if (living instanceof Player) {
            CarryOnData carry;
            Player player = (Player)living;
            if (Constants.CLIENT_CONFIG.renderArms && (carry = CarryOnDataManager.getCarryData(player)).isCarrying() && !player.m_6067_() && !player.m_21255_()) {
                boolean sneaking = !player.m_150110_().f_35935_ && player.m_6144_() || player.m_6047_();
                float x = 1.0f + (sneaking ? 0.2f : 0.0f) + (carry.isCarrying(CarryOnData.CarryType.BLOCK) ? 0.0f : 0.3f);
                float z = 0.05f;
                float width = CarryRenderHelper.getRenderWidth(player);
                float offset = Math.min((width - 1.0f) / 1.5f, 0.2f);
                if (carry.getActiveScript().isPresent()) {
                    CarryOnScript.ScriptRender render = carry.getActiveScript().get().scriptRender();
                    boolean renderLeft = render.renderLeftArm();
                    boolean renderRight = render.renderRightArm();
                    Vec3 rotLeft = render.renderRotationLeftArm().getVec(-x, -offset, z);
                    Vec3 rotRight = render.renderRotationRightArm().getVec(-x, offset, -z);
                    if (renderLeft) {
                        this.changeRotation(this.f_102812_, (float)rotLeft.f_82479_, (float)rotLeft.f_82480_, (float)rotLeft.f_82481_);
                    }
                    if (renderRight) {
                        this.changeRotation(this.f_102811_, (float)rotRight.f_82479_, (float)rotRight.f_82480_, (float)rotRight.f_82481_);
                    }
                } else {
                    this.changeRotation(this.f_102811_, -x, offset, -z);
                    this.changeRotation(this.f_102812_, -x, -offset, z);
                }
            }
        }
    }

    @Unique
    private void changeRotation(ModelPart part, float x, float y, float z) {
        part.f_104203_ = x;
        part.f_104204_ = y;
        part.f_104205_ = z;
    }
}

