/*
 * Decompiled with CFR 0.152.
 */
package portb.biggerstacks.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Surrogate;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import portb.biggerstacks.config.ClientConfig;

@Mixin(value={ItemRenderer.class})
public class ItemRendererMixin {
    private static final DecimalFormat BILLION_FORMAT = new DecimalFormat("#.##B");
    private static final DecimalFormat MILLION_FORMAT = new DecimalFormat("#.##M");
    private static final DecimalFormat THOUSAND_FORMAT = new DecimalFormat("#.##K");

    @Redirect(method={"renderGuiItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at=@At(value="INVOKE", target="Ljava/lang/String;valueOf(I)Ljava/lang/String;"))
    private String getStringForBigStackCount(int count) {
        if (((Boolean)ClientConfig.enableNumberShortening.get()).booleanValue()) {
            BigDecimal decimal = new BigDecimal(count).round(new MathContext(3));
            double value = decimal.doubleValue();
            if (value >= 1.0E9) {
                return BILLION_FORMAT.format(value / 1.0E9);
            }
            if (value >= 1000000.0) {
                return MILLION_FORMAT.format(value / 1000000.0);
            }
            if (value > 1000.0) {
                return THOUSAND_FORMAT.format(value / 1000.0);
            }
        }
        return String.valueOf(count);
    }

    @Surrogate
    @Inject(method={"renderGuiItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(DDD)V", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void pushStack(Font font, ItemStack tesselator, int x, int y, String j, CallbackInfo ci, PoseStack posestack, String countString) {
        posestack.m_85836_();
        float scale = (float)this.calculateStringScale(font, countString);
        posestack.m_85841_(scale, scale, 1.0f);
    }

    @Surrogate
    @Inject(method={"renderGuiItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/Font;drawInBatch(Ljava/lang/String;FFIZLcom/mojang/math/Matrix4f;Lnet/minecraft/client/renderer/MultiBufferSource;ZII)I")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void translateStackBack(Font font, ItemStack itemStack, int x, int y, String _a, CallbackInfo ci, PoseStack posestack, String countString, MultiBufferSource.BufferSource multibuffersource$buffersource) {
        int width = font.m_92895_(countString);
        double scale = this.calculateStringScale(font, countString);
        double extraXOffset = scale == 1.0 ? 0.0 : 1.0 / (scale * 2.0);
        double extraYOffset = scale == 1.0 ? 0.0 : 1.5 / scale;
        posestack.m_85837_((double)(-(x + 19 - 2 - width)), (double)(-(y + 6 + 3)), 0.0);
        posestack.m_85837_(((double)(x + 19 - 2) - extraXOffset - (double)width * scale) / scale, (double)(y + 6 + 3) / scale - (9.0 - 9.0 / scale) - extraYOffset, 0.0);
    }

    private double calculateStringScale(Font font, String countString) {
        int width = font.m_92895_(countString);
        if (width < 16) {
            return 1.0;
        }
        return 16.0 / (double)width;
    }

    @Surrogate
    @Inject(method={"renderGuiItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/Font;drawInBatch(Ljava/lang/String;FFIZLcom/mojang/math/Matrix4f;Lnet/minecraft/client/renderer/MultiBufferSource;ZII)I", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void popStack(Font font, ItemStack itemStack, int _a, int _b, String _c, CallbackInfo callbackInfo, PoseStack posestack, String s, MultiBufferSource.BufferSource bufferSource) {
        posestack.m_85849_();
    }
}

