/*
 * Decompiled with CFR 0.152.
 */
package portb.biggerstacks.mixin.client;

import java.nio.file.Path;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraftforge.fml.loading.FMLPaths;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import portb.biggerstacks.config.ClientConfig;
import portb.biggerstacks.config.ServerConfig;
import portb.biggerstacks.gui.HighStackSizeWarning;
import portb.biggerstacks.mixin.client.CreateWorldScreenInvoker;
import portb.configlib.ConfigLib;

@Mixin(value={CreateWorldScreen.class})
public class CreateWorldScreenMixin {
    @Overwrite
    void m_232937_(Button b) {
        this.wrapOnCreate();
    }

    @Redirect(method={"keyPressed"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/worldselection/CreateWorldScreen;onCreate()V"))
    private void showWarningBeforeWorldLoad(CreateWorldScreen instance) {
        this.wrapOnCreate();
    }

    private void wrapOnCreate() {
        if (!((Boolean)ClientConfig.stfuWarning.get()).booleanValue()) {
            int configMax = (Integer)ServerConfig.LOCAL_INSTANCE.maxStackCount.get();
            int actualMax = ConfigLib.readRuleset((Path)FMLPaths.CONFIGDIR.get().resolve("biggerstacks-rules.xml")).getMaxStacksize();
            if (configMax != 1 && actualMax > configMax) {
                HighStackSizeWarning.createWarningScreen(actualMax, () -> ((CreateWorldScreenInvoker)((Object)this)).invokeOnCreate());
                return;
            }
        }
        ((CreateWorldScreenInvoker)((Object)this)).invokeOnCreate();
    }
}

