/*
 * Decompiled with CFR 0.152.
 */
package portb.biggerstacks.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.ScreenUtils;
import portb.biggerstacks.Constants;
import portb.biggerstacks.gui.EditBoxWithADifferentBorderColour;
import portb.biggerstacks.net.ClientboundConfigureScreenOpenPacket;
import portb.biggerstacks.net.PacketHandler;
import portb.biggerstacks.net.ServerboundCreateConfigTemplatePacket;
import portb.configlib.template.TemplateOptions;

@OnlyIn(value=Dist.CLIENT)
public class ConfigureScreen
extends Screen {
    private static final int WIDTH = 200;
    private static final int HEIGHT = 180;
    private final TemplateOptions previousOptions;
    private final boolean isAlreadyUsingCustomFile;
    private MultiLineLabel OVERWRITE_WARNING_LABEL;
    private EditBox potionsBox;
    private EditBox enchBooksBox;
    private EditBox normalItemsBox;
    private Button confirmButton;

    protected ConfigureScreen(ClientboundConfigureScreenOpenPacket options) {
        super((Component)Component.m_237113_((String)"Configure stack size"));
        this.previousOptions = options;
        this.isAlreadyUsingCustomFile = options.isAlreadyUsingCustomFile();
    }

    public static void open(ClientboundConfigureScreenOpenPacket packet) {
        Minecraft.m_91087_().m_91152_((Screen)new ConfigureScreen(packet));
    }

    private static boolean isEditBoxInputValid(String inputString) {
        if (inputString.matches("[0-9]+")) {
            try {
                int value = Integer.parseInt(inputString);
                return value > 0 && value <= 0x3FFFFFFF;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    protected void m_7856_() {
        int relX = (this.f_96543_ - 200) / 2;
        int relY = (this.f_96544_ - 180) / 2;
        int editBoxStartX = 120;
        int editBoxStartY = 30;
        this.OVERWRITE_WARNING_LABEL = MultiLineLabel.m_94341_((Font)this.f_96547_, (FormattedText)Component.m_237115_((String)"biggerstacks.overwrite.warn").m_130948_(Style.f_131099_.m_178520_(0xFFAAAA)), (int)200);
        this.normalItemsBox = new EditBoxWithADifferentBorderColour(this.f_96547_, relX + editBoxStartX, relY + editBoxStartY, 60, 20, (Component)Component.m_237115_((String)"biggerstacks.normalbox.alt"));
        this.potionsBox = new EditBoxWithADifferentBorderColour(this.f_96547_, relX + editBoxStartX, relY + editBoxStartY + 30, 60, 20, (Component)Component.m_237115_((String)"biggerstacks.potsbox.alt"));
        this.enchBooksBox = new EditBoxWithADifferentBorderColour(this.f_96547_, relX + editBoxStartX, relY + editBoxStartY + 60, 60, 20, (Component)Component.m_237115_((String)"biggerstacks.enchbox.alt"));
        this.enchBooksBox.m_94144_("" + this.previousOptions.getEnchBookLimit());
        this.potionsBox.m_94144_("" + this.previousOptions.getPotionStackLimit());
        this.normalItemsBox.m_94144_("" + this.previousOptions.getNormalStackLimit());
        this.enchBooksBox.m_94151_(this.verifyInputBoxNumber(this.enchBooksBox));
        this.potionsBox.m_94151_(this.verifyInputBoxNumber(this.potionsBox));
        this.normalItemsBox.m_94151_(this.verifyInputBoxNumber(this.normalItemsBox));
        this.confirmButton = new Button(relX + 60, relY + 180 - 30, 80, 20, (Component)Component.m_237115_((String)"biggerstacks.save"), this::onConfirmButtonClicked);
        this.m_142416_((GuiEventListener)this.normalItemsBox);
        this.m_142416_((GuiEventListener)this.potionsBox);
        this.m_142416_((GuiEventListener)this.enchBooksBox);
        this.m_142416_((GuiEventListener)this.confirmButton);
        super.m_7856_();
    }

    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_96558_(pPoseStack, 0);
        int relX = (this.f_96543_ - 200) / 2;
        int relY = (this.f_96544_ - 180) / 2;
        ConfigureScreen.m_93215_((PoseStack)pPoseStack, (Font)this.f_96547_, (Component)Component.m_237115_((String)"biggerstacks.config.title"), (int)(this.f_96543_ / 2), (int)(relY + 10), (int)0xFFFFFF);
        Objects.requireNonNull(this.f_96547_);
        int centreOffset = (20 - 9) / 2;
        int labelStartX = 20;
        int labelStartY = 30;
        ConfigureScreen.m_93243_((PoseStack)pPoseStack, (Font)this.f_96547_, (Component)Component.m_237115_((String)"biggerstacks.normalbox.label"), (int)(relX + labelStartX), (int)(centreOffset + relY + labelStartY), (int)0xFFFFFF);
        ConfigureScreen.m_93243_((PoseStack)pPoseStack, (Font)this.f_96547_, (Component)Component.m_237115_((String)"biggerstacks.potsbox.label"), (int)(relX + labelStartX), (int)(centreOffset + relY + labelStartY + 30), (int)0xFFFFFF);
        ConfigureScreen.m_93243_((PoseStack)pPoseStack, (Font)this.f_96547_, (Component)Component.m_237115_((String)"biggerstacks.enchbox.label"), (int)(relX + labelStartX), (int)(centreOffset + relY + labelStartY + 60), (int)0xFFFFFF);
        if (this.isAlreadyUsingCustomFile) {
            this.OVERWRITE_WARNING_LABEL.m_6276_(pPoseStack, this.f_96543_ / 2, relY + 125);
        }
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    public void m_96558_(PoseStack pPoseStack, int pVOffset) {
        int relX = (this.f_96543_ - 200) / 2;
        int relY = (this.f_96544_ - 180) / 2;
        ScreenUtils.blitWithBorder((PoseStack)pPoseStack, (ResourceLocation)Constants.CONFIG_GUI_BG, (int)relX, (int)relY, (int)0, (int)0, (int)200, (int)180, (int)256, (int)256, (int)4, (float)0.0f);
    }

    private void onConfirmButtonClicked(Button button) {
        if (this.isStateValid()) {
            this.submit();
        }
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 257 && this.isStateValid()) {
            this.submit();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    private boolean isStateValid() {
        return ConfigureScreen.isEditBoxInputValid(this.normalItemsBox.m_94155_()) && ConfigureScreen.isEditBoxInputValid(this.enchBooksBox.m_94155_()) && ConfigureScreen.isEditBoxInputValid(this.potionsBox.m_94155_());
    }

    private void submit() {
        PacketHandler.INSTANCE.sendToServer((Object)new ServerboundCreateConfigTemplatePacket(Integer.parseInt(this.normalItemsBox.m_94155_()), Integer.parseInt(this.potionsBox.m_94155_()), Integer.parseInt(this.enchBooksBox.m_94155_())));
        Minecraft.m_91087_().m_91152_(null);
    }

    public boolean m_7043_() {
        return true;
    }

    private Consumer<String> verifyInputBoxNumber(EditBox editBox) {
        return inputString -> {
            if (ConfigureScreen.isEditBoxInputValid(inputString)) {
                editBox.m_94202_(0xFFFFFF);
                this.confirmButton.f_93623_ = true;
            } else {
                editBox.m_94202_(0xFF0000);
                this.confirmButton.f_93623_ = false;
            }
        };
    }
}

