/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.config;

import java.util.function.BiFunction;
import net.minecraftforge.common.ForgeConfigSpec;
import yesman.epicfight.api.utils.math.Vec2i;

public class WOMClientConfig {
    public final ForgeConfigSpec.BooleanValue stongerMobs;
    public final ForgeConfigSpec.BooleanValue mobsDropEmeralds;
    public final ForgeConfigSpec.BooleanValue mobsMoreXP;
    public final ForgeConfigSpec.BooleanValue skeletonMelee;
    public final ForgeConfigSpec.IntValue skeletonMeleePercent;
    private static final BiFunction<Integer, Integer, Integer> ORIGIN = (screenLength, value) -> value;
    private static final BiFunction<Integer, Integer, Integer> SCREEN_EDGE = (screenLength, value) -> screenLength - value;
    private static final BiFunction<Integer, Integer, Integer> CENTER = (screenLength, value) -> screenLength / 2 + value;
    private static final BiFunction<Integer, Integer, Integer> CENTER_SAVE = (screenLength, value) -> value - screenLength / 2;
    private static final StartCoordGetter START_HORIZONTAL = (x, y, width, height, icons, horBasis, verBasis) -> {
        if (horBasis == HorizontalBasis.CENTER) {
            return new Vec2i(x - width * (icons - 1) / 2, y);
        }
        return new Vec2i(x, y);
    };
    private static final StartCoordGetter START_VERTICAL = (x, y, width, height, icons, horBasis, verBasis) -> {
        if (verBasis == VerticalBasis.CENTER) {
            return new Vec2i(x, y - height * (icons - 1) / 2);
        }
        return new Vec2i(x, y);
    };
    private static final NextCoordGetter NEXT_HORIZONTAL = (horBasis, verBasis, oldPos, width, height) -> {
        if (horBasis == HorizontalBasis.LEFT || horBasis == HorizontalBasis.CENTER) {
            return new Vec2i(oldPos.x + width, oldPos.y);
        }
        return new Vec2i(oldPos.x - width, oldPos.y);
    };
    private static final NextCoordGetter NEXT_VERTICAL = (horBasis, verBasis, oldPos, width, height) -> {
        if (verBasis == VerticalBasis.TOP || verBasis == VerticalBasis.CENTER) {
            return new Vec2i(oldPos.x, oldPos.y + height);
        }
        return new Vec2i(oldPos.x, oldPos.y - height);
    };

    public WOMClientConfig(ForgeConfigSpec.Builder config) {
        this.stongerMobs = config.define("ingame.boosted_mob_over_distance", () -> true);
        this.mobsDropEmeralds = config.define("ingame.mob_drop_emerald_over_health", () -> true);
        this.mobsMoreXP = config.define("ingame.mob_more_xp_over_health", () -> true);
        this.skeletonMelee = config.define("ingame.skeleton_melee", () -> true);
        this.skeletonMeleePercent = config.defineInRange("ingame.skeleton_mele_percentage", 50, 1, 100);
    }

    public static enum VerticalBasis {
        TOP(ORIGIN, ORIGIN),
        BOTTOM(SCREEN_EDGE, SCREEN_EDGE),
        CENTER(CENTER, CENTER_SAVE);

        public BiFunction<Integer, Integer, Integer> positionGetter;
        public BiFunction<Integer, Integer, Integer> saveCoordGetter;

        private VerticalBasis(BiFunction<Integer, Integer, Integer> positionGetter, BiFunction<Integer, Integer, Integer> saveCoordGetter) {
            this.positionGetter = positionGetter;
            this.saveCoordGetter = saveCoordGetter;
        }
    }

    public static enum HorizontalBasis {
        LEFT(ORIGIN, ORIGIN),
        RIGHT(SCREEN_EDGE, SCREEN_EDGE),
        CENTER(CENTER, CENTER_SAVE);

        public BiFunction<Integer, Integer, Integer> positionGetter;
        public BiFunction<Integer, Integer, Integer> saveCoordGetter;

        private HorizontalBasis(BiFunction<Integer, Integer, Integer> positionGetter, BiFunction<Integer, Integer, Integer> saveCoordGetter) {
            this.positionGetter = positionGetter;
            this.saveCoordGetter = saveCoordGetter;
        }
    }

    @FunctionalInterface
    public static interface StartCoordGetter {
        public Vec2i get(int var1, int var2, int var3, int var4, int var5, HorizontalBasis var6, VerticalBasis var7);
    }

    @FunctionalInterface
    public static interface NextCoordGetter {
        public Vec2i getNext(HorizontalBasis var1, VerticalBasis var2, Vec2i var3, int var4, int var5);
    }

    public static enum HealthBarShowOptions {
        NONE,
        HURT,
        TARGET;


        public String toString() {
            return this.name().toLowerCase();
        }

        public HealthBarShowOptions nextOption() {
            return HealthBarShowOptions.values()[(this.ordinal() + 1) % 3];
        }
    }

    public static enum AlignDirection {
        HORIZONTAL(START_HORIZONTAL, NEXT_HORIZONTAL),
        VERTICAL(START_VERTICAL, NEXT_VERTICAL);

        public StartCoordGetter startCoordGetter;
        public NextCoordGetter nextPositionGetter;

        private AlignDirection(StartCoordGetter startCoordGetter, NextCoordGetter nextPositionGetter) {
            this.startCoordGetter = startCoordGetter;
            this.nextPositionGetter = nextPositionGetter;
        }
    }
}

