/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.harderspawners.config;

import com.mactso.harderspawners.config.MyConfig;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class MobSpawnerManager {
    public static Hashtable<String, MobSpawnerBreakPercentageItem> mobBreakPercentageHashtable = new Hashtable();
    private static String defaultMobBreakPercentageString;
    private static String defaultMobBreakPercentageKey;

    public static MobSpawnerBreakPercentageItem getMobSpawnerBreakPercentage(String key) {
        String iKey = key;
        if (mobBreakPercentageHashtable.isEmpty()) {
            MobSpawnerManager.mobBreakPercentageInit();
        }
        MobSpawnerBreakPercentageItem t = mobBreakPercentageHashtable.get(iKey);
        return t;
    }

    public static String getMobSpawnerBreakPercentageAsString() {
        Object returnString = "";
        for (String key : mobBreakPercentageHashtable.keySet()) {
            double breakPercentage = MobSpawnerManager.mobBreakPercentageHashtable.get((Object)key).breakPercentage;
            String tempString = key + "," + breakPercentage + ";";
            returnString = (String)returnString + tempString;
        }
        return returnString;
    }

    public static void mobBreakPercentageInit() {
        ArrayList<String> dTL6464 = new ArrayList<String>();
        System.out.println("HarderSpawners: Initialization Commencing.");
        int i = 0;
        String mobBreakPercentageLine6464 = "";
        StringTokenizer st6464 = new StringTokenizer(MyConfig.defaultMobBreakPercentageValues6464, ";");
        while (st6464.hasMoreElements()) {
            mobBreakPercentageLine6464 = st6464.nextToken().trim();
            if (mobBreakPercentageLine6464.isEmpty()) continue;
            dTL6464.add(mobBreakPercentageLine6464);
            ++i;
        }
        MyConfig.defaultMobBreakPercentageValues = dTL6464.toArray(new String[i]);
        mobBreakPercentageHashtable.clear();
        for (i = 0; i < MyConfig.defaultMobBreakPercentageValues.length; ++i) {
            try {
                String modAndMob;
                StringTokenizer st = new StringTokenizer(MyConfig.defaultMobBreakPercentageValues[i], ",");
                String key = modAndMob = st.nextToken();
                String breakPercentage = st.nextToken();
                double numericBreakPercentage = Double.parseDouble(breakPercentage.trim());
                if (numericBreakPercentage < 0.0 || numericBreakPercentage > 100.0) {
                    numericBreakPercentage = 0.02;
                }
                mobBreakPercentageHashtable.put(key, new MobSpawnerBreakPercentageItem(numericBreakPercentage));
                if (modAndMob.contentEquals("harderspawners:default") || ForgeRegistries.ENTITY_TYPES.containsKey(new ResourceLocation(modAndMob))) continue;
                System.out.println("Harder Spawners Mob: " + modAndMob + " not in Forge Registry.  Mispelled?");
                continue;
            }
            catch (Exception e) {
                System.out.println("Harder Spawners :  Mob Config : " + MyConfig.defaultMobBreakPercentageValues[i]);
            }
        }
        System.out.println("HarderSpawners: Initialization complete.");
    }

    static {
        defaultMobBreakPercentageKey = defaultMobBreakPercentageString = "harderspawners:default:0.02";
    }

    public static class MobSpawnerBreakPercentageItem {
        double breakPercentage;

        public MobSpawnerBreakPercentageItem(double breakPercentage) {
            this.breakPercentage = breakPercentage;
        }

        public double getSpawnerBreakPercentage() {
            return this.breakPercentage;
        }
    }
}

