/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item.crafting;

import com.google.gson.JsonObject;
import com.magistuarmory.item.ArmorDecoration;
import com.magistuarmory.item.crafting.forge.ArmorDecorationRecipeImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class ArmorDecorationRecipe
extends CustomRecipe {
    public static RecipeSerializer<ArmorDecorationRecipe> SERIALIZER = new RecipeSerializer<ArmorDecorationRecipe>(){

        public ArmorDecorationRecipe fromJson(ResourceLocation location, JsonObject json) {
            return new ArmorDecorationRecipe(location);
        }

        public ArmorDecorationRecipe fromNetwork(ResourceLocation location, FriendlyByteBuf buf) {
            return new ArmorDecorationRecipe(location);
        }

        public void toNetwork(FriendlyByteBuf buf, ArmorDecorationRecipe recipe) {
        }
    };

    public ArmorDecorationRecipe(ResourceLocation location) {
        super(location);
    }

    public boolean matches(CraftingContainer container, Level level) {
        ItemStack armorstack = ItemStack.f_41583_;
        ItemStack decorationstack = ItemStack.f_41583_;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof ArmorDecoration) {
                if (!decorationstack.m_41619_()) {
                    return false;
                }
                decorationstack = stack;
                continue;
            }
            if (stack.m_41720_() instanceof ArmorItem) {
                if (!armorstack.m_41619_()) {
                    return false;
                }
                armorstack = stack;
                continue;
            }
            return false;
        }
        Item item = decorationstack.m_41720_();
        if (item instanceof ArmorDecoration) {
            ArmorDecoration decoration = (ArmorDecoration)item;
            return decoration.isApplicableForDecoration(armorstack);
        }
        return false;
    }

    public ItemStack assemble(CraftingContainer container) {
        Item item;
        ItemStack armorstack = ItemStack.f_41583_;
        ItemStack decorationstack = ItemStack.f_41583_;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof ArmorDecoration) {
                decorationstack = stack;
                continue;
            }
            if (!(stack.m_41720_() instanceof ArmorItem)) continue;
            armorstack = stack.m_41777_();
        }
        if (!armorstack.m_41619_() && !decorationstack.m_41619_() && (item = decorationstack.m_41720_()) instanceof ArmorDecoration) {
            ArmorDecoration decoration = (ArmorDecoration)item;
            decoration.decorate(armorstack, decorationstack);
        }
        return armorstack;
    }

    public boolean m_8004_(int n, int m) {
        return n * m >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return ArmorDecorationRecipe.getSerializerInstance();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static RecipeSerializer<ArmorDecorationRecipe> getSerializerInstance() {
        return ArmorDecorationRecipeImpl.getSerializerInstance();
    }
}

