/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item;

import com.magistuarmory.client.render.ModRender;
import com.magistuarmory.client.render.tileentity.HeraldryItemStackRenderer;
import com.magistuarmory.item.IHasModelProperty;
import com.magistuarmory.item.ModItemTier;
import com.magistuarmory.item.ShieldType;
import com.magistuarmory.util.CombatHelper;
import com.magistuarmory.util.ModDamageSources;
import dev.architectury.platform.Platform;
import dev.architectury.registry.item.ItemPropertiesRegistry;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MedievalShieldItem
extends ShieldItem
implements IHasModelProperty {
    private final ShieldType type;
    private final String id;
    private final ResourceLocation location;
    private final boolean is3d;
    private Supplier<Ingredient> repairItem = () -> Ingredient.m_204132_((TagKey)ItemTags.f_13168_);
    protected HeraldryItemStackRenderer renderer;
    private final boolean paintable;
    private final float maxBlockDamage;
    private final float weight;

    public MedievalShieldItem(String id, ResourceLocation location, Item.Properties properties, ModItemTier material, boolean paintable, boolean is3d, ShieldType type) {
        super(properties.m_41503_(type.getDurability(material)));
        this.type = type;
        this.id = id;
        this.location = location;
        this.is3d = is3d;
        this.paintable = paintable;
        this.maxBlockDamage = type.getMaxBlockDamage() + material.m_6631_();
        this.weight = type.getWeight() + material.m_6631_();
        if (type.isRepairable()) {
            this.repairItem = material::m_6282_;
        }
        if (this.is3d && Platform.getEnv() == Dist.CLIENT) {
            this.renderer = ModRender.createHeraldryItemStackRenderer(this.id, this.location);
        }
    }

    public String getId() {
        return this.id;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.m_237110_((String)"maxdamageblock", (Object[])new Object[]{Float.valueOf(this.getMaxBlockDamage())}).m_130940_(ChatFormatting.BLUE));
        list.add((Component)Component.m_237110_((String)"kgweight", (Object[])new Object[]{Float.valueOf(this.getWeight())}).m_130940_(ChatFormatting.BLUE));
        if (this.getWeight() >= 10.0f) {
            list.add((Component)Component.m_237115_((String)"slowmovementspeed").m_130940_(ChatFormatting.RED));
        }
        BannerItem.m_40542_((ItemStack)stack, list);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int i, boolean selected) {
        LivingEntity livingentity;
        if (this.getWeight() >= 10.0f && entity instanceof LivingEntity && ((livingentity = (LivingEntity)entity).m_21206_() == stack || livingentity.m_21205_() == stack)) {
            livingentity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 0, false, false, false));
        }
        super.m_6883_(stack, level, entity, i, selected);
    }

    protected float getWeight() {
        return this.weight;
    }

    public String m_5671_(ItemStack stack) {
        return super.m_5524_();
    }

    public int m_8105_(ItemStack stack) {
        return (int)(12000.0f * this.weight);
    }

    public boolean m_6832_(ItemStack stack, ItemStack stack2) {
        return this.repairItem.get().test(stack2);
    }

    public boolean isPaintable() {
        return this.paintable;
    }

    public void loadModel(EntityModelSet context) {
        if (this.is3d) {
            this.renderer.loadModel(context);
        }
    }

    public HeraldryItemStackRenderer getRenderer() {
        return this.renderer;
    }

    public float getMaxBlockDamage() {
        return this.maxBlockDamage;
    }

    public void onBlocked(ItemStack stack, float damage, LivingEntity victim, DamageSource source) {
        try {
            if (ModDamageSources.isAdditional(source)) {
                return;
            }
        }
        catch (NullPointerException e) {
            System.out.println(e.getMessage());
            return;
        }
        Entity attacker = source.m_7639_();
        float f = CombatHelper.getArmorPiercingFactor(attacker);
        if (damage > this.getMaxBlockDamage()) {
            f *= 1.5f;
            float damage2 = damage - this.getMaxBlockDamage();
            victim.m_6469_(ModDamageSources.additional(), damage2);
        }
        stack.m_41622_((int)(f * damage), victim, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerModelProperty() {
        ItemPropertiesRegistry.register((ItemLike)this, (ResourceLocation)new ResourceLocation("blocking"), (stack, level, entity, i) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
    }

    public boolean is3d() {
        return this.is3d;
    }
}

