/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.client.render.tileentity;

import com.magistuarmory.block.PaviseBlockEntity;
import com.magistuarmory.client.render.PatternLayer;
import com.magistuarmory.client.render.model.ModModels;
import com.magistuarmory.client.render.model.block.PaviseBlockModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PaviseBlockRenderer
implements BlockEntityRenderer<PaviseBlockEntity> {
    public static String DIR_PREFIX = "entity/pavese/";
    PaviseBlockModel model;
    ModelPart handle;
    ModelPart[] plate;

    public PaviseBlockRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new PaviseBlockModel(context.m_173582_(ModModels.PAVISE_BLOCK_LOCATION));
        this.handle = this.model.handle();
        this.plate = this.model.plate();
    }

    public int m_142163_() {
        return 128;
    }

    public void render(PaviseBlockEntity pavise, float f, PoseStack pose, MultiBufferSource buffer, int p, int overlay) {
        pose.m_85836_();
        BlockState blockstate = pavise.m_58900_();
        pose.m_85837_(0.5, 0.5, 0.5);
        float yrot = (float)(-((Integer)blockstate.m_61143_((Property)BannerBlock.f_49007_)).intValue() * 360) / 16.0f;
        pose.m_85845_(Vector3f.f_122225_.m_122240_(yrot));
        pose.m_85836_();
        pose.m_85841_(1.0f, -1.0f, -1.0f);
        boolean painted = pavise.isPainted();
        Material material = new Material(Sheets.f_110738_, new ResourceLocation("magistuarmory", "entity/" + pavise.getShieldId() + (painted ? "_pattern" : "_nopattern")));
        VertexConsumer vertexconsumer = material.m_119204_().m_118381_(ItemRenderer.m_115222_((MultiBufferSource)buffer, (RenderType)this.model.m_103119_(material.m_119193_()), (boolean)true, (boolean)pavise.hasFoil()));
        this.handle.m_104301_(pose, vertexconsumer, p, OverlayTexture.f_118083_);
        for (ModelPart part : this.plate) {
            part.m_104301_(pose, vertexconsumer, p, OverlayTexture.f_118083_);
        }
        if (painted) {
            List<Pair<Holder<BannerPattern>, DyeColor>> list = pavise.getPatterns();
            PaviseBlockRenderer.renderPatterns(pose, buffer, p, OverlayTexture.f_118083_, list, this.plate, ModelBakery.f_119224_, pavise.hasFoil());
        }
        pose.m_85849_();
        pose.m_85849_();
    }

    public static void renderPatterns(PoseStack pose, MultiBufferSource buffer, int p, int overlay, List<Pair<Holder<BannerPattern>, DyeColor>> list, ModelPart[] modelparts, Material basematerial, boolean hasfoil) {
        list = PatternLayer.filterFromUnregistered(list);
        for (ModelPart part : modelparts) {
            for (int i = 0; i < 17 && i < list.size(); ++i) {
                Pair<Holder<BannerPattern>, DyeColor> pair = list.get(i);
                float[] color = ((DyeColor)pair.getSecond()).m_41068_();
                if (!((Holder)pair.getFirst()).m_203543_().isPresent()) continue;
                Material material = new Material(Sheets.f_110738_, new ResourceLocation("magistuarmory", DIR_PREFIX + ((ResourceKey)((Holder)pair.getFirst()).m_203543_().get()).m_135782_().m_135815_()));
                part.m_104306_(pose, material.m_119197_(buffer, RenderType::m_110482_, hasfoil), p, overlay, color[0], color[1], color[2], 1.0f);
            }
        }
    }
}

