/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.client.render;

import com.magistuarmory.api.item.ModItemsProvider;
import com.magistuarmory.block.ModBlockEntityTypes;
import com.magistuarmory.client.render.forge.ModRenderImpl;
import com.magistuarmory.client.render.tileentity.HeraldryItemStackRenderer;
import com.magistuarmory.client.render.tileentity.PaviseBlockRenderer;
import com.magistuarmory.item.IHasModelProperty;
import com.magistuarmory.item.MedievalShieldItem;
import com.magistuarmory.item.ModItems;
import com.magistuarmory.item.armor.MedievalArmorItem;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModRender {
    public static void setup(ModItemsProvider content) {
        for (RegistrySupplier<? extends Item> registrySupplier : content.dyeableItems) {
            ColorHandlerRegistry.registerItemColors((stack, i) -> i > 0 ? -1 : ((DyeableLeatherItem)stack.m_41720_()).m_41121_(stack), (ItemLike[])new ItemLike[]{(ItemLike)registrySupplier.get()});
        }
        for (RegistrySupplier registrySupplier : content.items) {
            Object object = registrySupplier.get();
            if (!(object instanceof IHasModelProperty)) continue;
            IHasModelProperty havingproperty = (IHasModelProperty)object;
            havingproperty.registerModelProperty();
        }
        ModRender.setupPlatform(content);
    }

    public static void stitch(TextureAtlas atlas, Consumer<ResourceLocation> adder) {
        ModItems.HEATER_SHIELDS.stitch(atlas, adder);
        ModItems.RONDACHES.stitchWithoutPatterns(atlas, adder);
        ModItems.TARTSCHES.stitch(atlas, adder);
        ModItems.ELLIPTICAL_SHIELDS.stitch(atlas, adder);
        ModItems.ROUND_SHIELDS.stitch(atlas, adder);
        ModItems.PAVISES.stitch(atlas, adder);
        ModItems.KITE_SHIELDS.stitch(atlas, adder);
        ModItems.BUCKLERS.stitchWithoutPatterns(atlas, adder);
        ModItems.TARGETS.stitchWithoutPatterns(atlas, adder);
        if (atlas.m_118330_() == Sheets.f_110738_) {
            adder.accept(new ResourceLocation("magistuarmory", "entity/corruptedroundshield_nopattern"));
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setupPlatform(ModItemsProvider content) {
        ModRenderImpl.setupPlatform(content);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerModelsLoadListener(ModItemsProvider content) {
        ModRenderImpl.registerModelsLoadListener(content);
    }

    public static void registerRenderers() {
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)ModBlockEntityTypes.PAVISE.get()), PaviseBlockRenderer::new);
    }

    public static void loadModels(ModItemsProvider content, EntityModelSet context) {
        for (Supplier supplier : content.shieldItems) {
            ((MedievalShieldItem)supplier.get()).loadModel(context);
        }
        for (Supplier supplier : content.armorItems) {
            ((MedievalArmorItem)supplier.get()).loadModel(context);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static HeraldryItemStackRenderer createHeraldryItemStackRenderer(String id, ResourceLocation location) {
        void var1_1;
        return ModRenderImpl.createHeraldryItemStackRenderer(id, (ResourceLocation)var1_1);
    }
}

