/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.config;

import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.jodah.typetools.TypeResolver;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;

public final class AstikorCartsConfig {
    public static Common get() {
        return Holder.COMMON;
    }

    public static ForgeConfigSpec spec() {
        return Holder.COMMON_SPEC;
    }

    private static final class Holder {
        private static final Common COMMON;
        private static final ForgeConfigSpec COMMON_SPEC;

        private Holder() {
        }

        static {
            Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
            COMMON = (Common)specPair.getLeft();
            COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        }
    }

    public static class Common {
        public final CartConfig supplyCart;
        public final CartConfig animalCart;
        public final CartConfig plow;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Configuration for all carts and cart-like vehicles, check log for automatic \"pull_animals\" list.").push("carts");
            this.supplyCart = new CartConfig(builder, "supply_cart", "The Supply Cart, a type of cart that stores items");
            this.animalCart = new CartConfig(builder, "animal_cart", "The Animal Cart, a type of cart to haul other animals");
            this.plow = new CartConfig(builder, "plow", "The Plow, an animal pulled machine for tilling soil and creating paths");
            builder.pop();
        }

        public static String getComment() {
            return "pull_animals = " + Common.referencePullAnimals();
        }

        static String referencePullAnimals() {
            return "[\n" + StreamSupport.stream(ForgeRegistries.ENTITY_TYPES.spliterator(), false).filter(type -> {
                Class entityClass = TypeResolver.resolveRawArgument(EntityType.EntityFactory.class, Objects.requireNonNull(ObfuscationReflectionHelper.getPrivateValue(EntityType.class, (Object)type, (String)"f_20535_"), "factory").getClass());
                if (Entity.class.equals((Object)entityClass)) {
                    return type == EntityType.f_20532_;
                }
                return Saddleable.class.isAssignableFrom(entityClass) && !ItemSteerable.class.isAssignableFrom(entityClass) && !Llama.class.isAssignableFrom(entityClass);
            }).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENTITY_TYPES).getKey(arg_0)).filter(Objects::nonNull).map(type -> "    \"" + type + "\"").collect(Collectors.joining(",\n")) + "\n  ]";
        }
    }

    public static class CartConfig {
        public final ForgeConfigSpec.ConfigValue<ArrayList<String>> pullAnimals;
        public final ForgeConfigSpec.DoubleValue slowSpeed;
        public final ForgeConfigSpec.DoubleValue pullSpeed;

        CartConfig(ForgeConfigSpec.Builder builder, String name, String description) {
            builder.comment(description).push(name);
            this.pullAnimals = builder.comment("Animals that are able to pull this cart, such as [\"minecraft:horse\"]\nAn empty list defaults to all which may wear a saddle but not steered by an item").define("pull_animals", new ArrayList());
            this.slowSpeed = builder.comment("Slow speed modifier toggled by the sprint key").defineInRange("slow_speed", -0.65, -1.0, 0.0);
            this.pullSpeed = builder.comment("Base speed modifier applied to animals (-0.5 = half normal speed)").defineInRange("pull_speed", 0.0, -1.0, 0.0);
            builder.pop();
        }
    }
}

