/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.origins.common.network;

import io.github.apace100.origins.Origins;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.capabilities.IOriginContainer;
import io.github.edwinmindcraft.origins.api.origin.Origin;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import io.github.edwinmindcraft.origins.api.registry.OriginsDynamicRegistries;
import io.github.edwinmindcraft.origins.common.OriginsCommon;
import io.github.edwinmindcraft.origins.common.network.S2CConfirmOrigin;
import io.github.edwinmindcraft.origins.common.registry.OriginRegisters;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public record C2SChooseRandomOrigin(ResourceLocation layer) {
    public static C2SChooseRandomOrigin decode(FriendlyByteBuf buf) {
        return new C2SChooseRandomOrigin(buf.m_130281_());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.layer());
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            if (sender == null) {
                return;
            }
            IOriginContainer.get((Entity)sender).ifPresent(container -> {
                Optional<Holder> layer = OriginsAPI.getLayersRegistry().m_203636_(ResourceKey.m_135785_(OriginsDynamicRegistries.LAYERS_REGISTRY, (ResourceLocation)this.layer())).filter(Holder::m_203633_);
                if (layer.isEmpty()) {
                    Origins.LOGGER.warn("Player {} tried to select a random origin for missing layer {}", (Object)sender.m_6302_(), (Object)this.layer());
                    return;
                }
                if (container.hasAllOrigins() || container.hasOrigin((Holder<OriginLayer>)layer.get())) {
                    Origins.LOGGER.warn("Player {} tried to choose origin for layer {} while having one already.", (Object)sender.m_6302_(), (Object)this.layer());
                    return;
                }
                Optional<Holder<Origin>> selected = ((OriginLayer)layer.get().m_203334_()).selectRandom((Player)sender);
                if (!((OriginLayer)layer.get().m_203334_()).allowRandom() || selected.isEmpty()) {
                    Origins.LOGGER.warn("Player {} tried to choose a random Origin for layer {}, which is not allowed!", (Object)sender.m_6302_(), (Object)this.layer());
                    container.setOrigin((Holder<OriginLayer>)layer.get(), (Holder<Origin>)((Holder)OriginRegisters.EMPTY.getHolder().orElseThrow()));
                    return;
                }
                Holder<Origin> origin = selected.get();
                boolean hadOriginBefore = container.hadAllOrigins();
                boolean hadAllOrigins = container.hasAllOrigins();
                container.setOrigin((Holder<OriginLayer>)layer.get(), origin);
                container.checkAutoChoosingLayers(false);
                container.synchronize();
                if (container.hasAllOrigins() && !hadAllOrigins) {
                    container.onChosen(hadOriginBefore);
                }
                Origins.LOGGER.info("Player {} was randomly assigned the following Origin: \"{}\" for layer: {}", (Object)sender.m_6302_(), origin.m_203543_().orElse(null), (Object)this.layer());
                OriginsCommon.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sender), (Object)new S2CConfirmOrigin(this.layer(), origin.m_203543_().map(ResourceKey::m_135782_).orElse(null)));
            });
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

