/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.apace100.origins.badge.Badge;
import io.github.apace100.origins.badge.BadgeManager;
import io.github.apace100.origins.mixin.ScreenAccessor;
import io.github.apace100.origins.origin.Impact;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.origin.Origin;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class OriginDisplayScreen
extends Screen {
    private static final ResourceLocation WINDOW = new ResourceLocation("origins", "textures/gui/choose_origin.png");
    @NotNull
    private Holder<Origin> origin = OriginDisplayScreen.unboundOrigin();
    @NotNull
    private Holder<OriginLayer> layer = OriginDisplayScreen.unboundLayer();
    private boolean isOriginRandom;
    private Component randomOriginText;
    protected static final int windowWidth = 176;
    protected static final int windowHeight = 182;
    protected int scrollPos = 0;
    private int currentMaxScroll = 0;
    protected float time = 0.0f;
    protected int guiTop;
    protected int guiLeft;
    protected final boolean showDirtBackground;
    private final LinkedList<RenderedBadge> renderedBadges = new LinkedList();
    private boolean scrolling = false;
    private int scrollDragStart = 0;
    private double mouseDragStart = 0.0;

    private static Holder<Origin> unboundOrigin() {
        return Holder.Reference.m_205766_(OriginsAPI.getOriginsRegistry(null), null);
    }

    private static Holder<OriginLayer> unboundLayer() {
        return Holder.Reference.m_205766_(OriginsAPI.getLayersRegistry(null), null);
    }

    public OriginDisplayScreen(Component title, boolean showDirtBackground) {
        super(title);
        this.showDirtBackground = showDirtBackground;
        this.showNone();
    }

    public void showNone() {
        this.showOrigin(OriginDisplayScreen.unboundOrigin(), OriginDisplayScreen.unboundLayer(), false);
    }

    public void showOrigin(Holder<Origin> origin, Holder<OriginLayer> layer, boolean isRandom) {
        this.origin = origin;
        this.layer = layer;
        this.isOriginRandom = isRandom;
        this.scrollPos = 0;
        this.time = 0.0f;
    }

    public void setRandomOriginText(Component text) {
        this.randomOriginText = text;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.guiLeft = (this.f_96543_ - 176) / 2;
        this.guiTop = (this.f_96544_ - 182) / 2;
    }

    @NotNull
    public Holder<Origin> getCurrentOrigin() {
        return this.origin;
    }

    @NotNull
    public Holder<OriginLayer> getCurrentLayer() {
        return this.layer;
    }

    public void m_96558_(@NotNull PoseStack matrices, int vOffset) {
        if (this.showDirtBackground) {
            super.m_96626_(vOffset);
        } else {
            super.m_96558_(matrices, vOffset);
        }
    }

    public void m_6305_(@NotNull PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.renderedBadges.clear();
        this.time += delta;
        this.m_7333_(matrices);
        this.renderOriginWindow(matrices, mouseX, mouseY);
        super.m_6305_(matrices, mouseX, mouseY, delta);
        if (this.origin.m_203633_()) {
            this.renderScrollbar(matrices, mouseX, mouseY);
            this.renderBadgeTooltip(matrices, mouseX, mouseY);
        }
    }

    private void renderScrollbar(PoseStack matrices, int mouseX, int mouseY) {
        if (!this.canScroll()) {
            return;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)WINDOW);
        this.m_93228_(matrices, this.guiLeft + 155, this.guiTop + 35, 188, 24, 8, 134);
        int scrollbarY = 36;
        int maxScrollbarOffset = 141;
        int u = 176;
        float part = (float)this.scrollPos / (float)this.currentMaxScroll;
        scrollbarY = (int)((float)scrollbarY + (float)(maxScrollbarOffset - scrollbarY) * part);
        if (this.scrolling) {
            u += 6;
        } else if (mouseX >= this.guiLeft + 156 && mouseX < this.guiLeft + 156 + 6 && mouseY >= this.guiTop + scrollbarY && mouseY < this.guiTop + scrollbarY + 27) {
            u += 6;
        }
        this.m_93228_(matrices, this.guiLeft + 156, this.guiTop + scrollbarY, u, 24, 6, 27);
    }

    private boolean canScroll() {
        return this.origin.m_203633_() && this.currentMaxScroll > 0;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.canScroll()) {
            this.scrolling = false;
            int scrollbarY = 36;
            int maxScrollbarOffset = 141;
            float part = (float)this.scrollPos / (float)this.currentMaxScroll;
            scrollbarY = (int)((float)scrollbarY + (float)(maxScrollbarOffset - scrollbarY) * part);
            if (mouseX >= (double)(this.guiLeft + 156) && mouseX < (double)(this.guiLeft + 156 + 6) && mouseY >= (double)(this.guiTop + scrollbarY) && mouseY < (double)(this.guiTop + scrollbarY + 27)) {
                this.scrolling = true;
                this.scrollDragStart = scrollbarY;
                this.mouseDragStart = mouseY;
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrolling) {
            int delta = (int)(mouseY - this.mouseDragStart);
            int newScrollPos = Math.max(36, Math.min(141, this.scrollDragStart + delta));
            float part = (float)(newScrollPos - 36) / 105.0f;
            this.scrollPos = (int)(part * (float)this.currentMaxScroll);
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    private void renderBadgeTooltip(PoseStack matrices, int mouseX, int mouseY) {
        for (RenderedBadge rb : this.renderedBadges) {
            if (mouseX < rb.x || mouseX >= rb.x + 9 || mouseY < rb.y || mouseY >= rb.y + 9 || !rb.hasTooltip()) continue;
            int widthLimit = this.f_96543_ - mouseX - 24;
            ((ScreenAccessor)((Object)this)).invokeRenderTooltipFromComponents(matrices, rb.getTooltipComponents(this.f_96547_, widthLimit), mouseX, mouseY);
        }
    }

    protected Component getTitleText() {
        return Component.m_237113_((String)"Origins");
    }

    private void renderOriginWindow(PoseStack matrices, int mouseX, int mouseY) {
        RenderSystem.m_69478_();
        this.renderWindowBackground(matrices, 16, 0);
        if (this.origin.m_203633_()) {
            this.renderOriginContent(matrices, mouseX, mouseY);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)WINDOW);
        this.m_93228_(matrices, this.guiLeft, this.guiTop, 0, 0, 176, 182);
        if (this.origin.m_203633_()) {
            this.renderOriginName(matrices);
            RenderSystem.m_157456_((int)0, (ResourceLocation)WINDOW);
            this.renderOriginImpact(matrices, mouseX, mouseY);
            Component title = this.getTitleText();
            OriginDisplayScreen.m_93208_((PoseStack)matrices, (Font)this.f_96547_, (String)title.getString(), (int)(this.f_96543_ / 2), (int)(this.guiTop - 15), (int)0xFFFFFF);
        }
        RenderSystem.m_69461_();
    }

    private void renderOriginImpact(PoseStack matrices, int mouseX, int mouseY) {
        Impact impact = ((Origin)this.getCurrentOrigin().get()).getImpact();
        int impactValue = impact.getImpactValue();
        int wOffset = impactValue * 8;
        for (int i = 0; i < 3; ++i) {
            if (i < impactValue) {
                this.m_93228_(matrices, this.guiLeft + 128 + i * 10, this.guiTop + 19, 176 + wOffset, 16, 8, 8);
                continue;
            }
            this.m_93228_(matrices, this.guiLeft + 128 + i * 10, this.guiTop + 19, 176, 16, 8, 8);
        }
        if (mouseX >= this.guiLeft + 128 && mouseX <= this.guiLeft + 158 && mouseY >= this.guiTop + 19 && mouseY <= this.guiTop + 27) {
            MutableComponent ttc = Component.m_237115_((String)"origins.gui.impact.impact").m_130946_(": ").m_7220_((Component)impact.getTextComponent());
            this.m_96602_(matrices, (Component)ttc, mouseX, mouseY);
        }
    }

    private void renderOriginName(PoseStack matrices) {
        FormattedText originName = this.f_96547_.m_92854_((FormattedText)((Origin)this.getCurrentOrigin().get()).getName(), 140);
        OriginDisplayScreen.m_93236_((PoseStack)matrices, (Font)this.f_96547_, (String)originName.getString(), (int)(this.guiLeft + 39), (int)(this.guiTop + 19), (int)0xFFFFFF);
        ItemStack is = ((Origin)this.getCurrentOrigin().get()).getIcon();
        this.f_96542_.m_115123_(is, this.guiLeft + 15, this.guiTop + 15);
    }

    protected void renderWindowBackground(PoseStack matrices, int offsetYStart, int offsetYEnd) {
        int border = 13;
        int endX = this.guiLeft + 176 - border;
        int endY = this.guiTop + 182 - border;
        RenderSystem.m_157456_((int)0, (ResourceLocation)WINDOW);
        for (int x = this.guiLeft; x < endX; x += 16) {
            for (int y = this.guiTop + offsetYStart; y < endY + offsetYEnd; y += 16) {
                this.m_93228_(matrices, x, y, 176, 0, Math.max(16, endX - x), Math.max(16, endY + offsetYEnd - y));
            }
        }
    }

    public boolean m_6050_(double x, double y, double z) {
        boolean retValue = super.m_6050_(x, y, z);
        int np = this.scrollPos - (int)z * 4;
        this.scrollPos = np < 0 ? 0 : Math.min(np, this.currentMaxScroll);
        return retValue;
    }

    private void renderOriginContent(PoseStack matrices, int mouseX, int mouseY) {
        int y;
        int textWidth = 128;
        Origin origin = (Origin)this.getCurrentOrigin().get();
        int x = this.guiLeft + 18;
        int startY = y = this.guiTop + 50;
        int endY = y - 72 + 182;
        y -= this.scrollPos;
        Component orgDesc = origin.getDescription();
        List descLines = this.f_96547_.m_92923_((FormattedText)orgDesc, textWidth);
        for (FormattedCharSequence line : descLines) {
            if (y >= startY - 18 && y <= endY + 12) {
                this.f_96547_.m_92877_(matrices, line, (float)(x + 2), (float)(y - 6), 0xCCCCCC);
            }
            y += 12;
        }
        if (this.isOriginRandom) {
            List drawLines = this.f_96547_.m_92923_((FormattedText)this.randomOriginText, textWidth);
            for (FormattedCharSequence formattedCharSequence : drawLines) {
                if ((y += 12) < startY - 24 || y > endY + 12) continue;
                this.f_96547_.m_92877_(matrices, formattedCharSequence, (float)(x + 2), (float)y, 0xCCCCCC);
            }
            y += 14;
        } else {
            Registry powers = ApoliAPI.getPowers();
            for (Holder holder : origin.getValidPowers().toList()) {
                Optional<ResourceLocation> id;
                if (!holder.m_203633_() || ((ConfiguredPower)holder.get()).getData().hidden() || (id = ((Optional)holder.m_203439_().map(Optional::of, arg_0 -> ((Registry)powers).m_7854_(arg_0))).map(ResourceKey::m_135782_)).isEmpty()) continue;
                ConfiguredPower p = (ConfiguredPower)holder.get();
                FormattedCharSequence name = Language.m_128107_().m_5536_(this.f_96547_.m_92854_((FormattedText)p.getData().getName().m_130940_(ChatFormatting.UNDERLINE), textWidth));
                MutableComponent desc = p.getData().getDescription();
                List drawLines = this.f_96547_.m_92923_((FormattedText)desc, textWidth);
                if (y >= startY - 24 && y <= endY + 12) {
                    this.f_96547_.m_92877_(matrices, name, (float)x, (float)y, 0xFFFFFF);
                    int tw = this.f_96547_.m_92724_(name);
                    List<Badge> badges = BadgeManager.getPowerBadges(id.get());
                    int xStart = x + tw + 4;
                    int bi = 0;
                    for (Badge badge : badges) {
                        RenderedBadge renderedBadge = new RenderedBadge(p, badge, xStart + 10 * bi, y - 1);
                        this.renderedBadges.add(renderedBadge);
                        RenderSystem.m_157456_((int)0, (ResourceLocation)badge.spriteId());
                        OriginDisplayScreen.m_93133_((PoseStack)matrices, (int)(xStart + 10 * bi), (int)(y - 1), (float)0.0f, (float)0.0f, (int)9, (int)9, (int)9, (int)9);
                        ++bi;
                    }
                }
                for (FormattedCharSequence line : drawLines) {
                    if ((y += 12) < startY - 24 || y > endY + 12) continue;
                    this.f_96547_.m_92877_(matrices, line, (float)(x + 2), (float)y, 0xCCCCCC);
                }
                y += 14;
            }
        }
        this.currentMaxScroll = (y += this.scrollPos) - 14 - (this.guiTop + 158);
        if (this.currentMaxScroll < 0) {
            this.currentMaxScroll = 0;
        }
    }

    private class RenderedBadge {
        private final ConfiguredPower<?, ?> powerType;
        private final Badge badge;
        private final int x;
        private final int y;

        public RenderedBadge(ConfiguredPower<?, ?> powerType, Badge badge, int x, int y) {
            this.powerType = powerType;
            this.badge = badge;
            this.x = x;
            this.y = y;
        }

        public boolean hasTooltip() {
            return this.badge.hasTooltip();
        }

        public List<ClientTooltipComponent> getTooltipComponents(Font textRenderer, int widthLimit) {
            return this.badge.getTooltipComponents(this.powerType, widthLimit, OriginDisplayScreen.this.time, textRenderer);
        }
    }
}

