/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import com.google.common.base.Stopwatch;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.events.EarlyPackReloadEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcePack;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.misc.VanillaResourceManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class DynResourceProvider<T extends DynamicResourcePack>
implements PreparableReloadListener {
    public final T dynamicPack;
    private boolean hasBeenInitialized;

    protected DynResourceProvider(T pack) {
        this.dynamicPack = pack;
    }

    public void register() {
        ((DynamicResourcePack)this.dynamicPack).registerPack();
        MoonlightEventsHelper.addListener(this::onEarlyReload, EarlyPackReloadEvent.class);
    }

    public abstract Logger getLogger();

    public T getPack() {
        return this.dynamicPack;
    }

    public abstract boolean dependsOnLoadedPacks();

    public abstract void regenerateDynamicAssets(ResourceManager var1);

    @Deprecated(forRemoval=true)
    public void generateStaticAssetsOnStartup(ResourceManager manager) {
    }

    public final CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, ResourceManager manager, ProfilerFiller workerProfiler, ProfilerFiller mainProfiler, Executor workerExecutor, Executor mainExecutor) {
        if (PlatformHelper.isModLoadingValid()) {
            this.onNormalReload(manager);
        } else {
            Moonlight.LOGGER.error("Cowardly refusing generate assets for a broken mod state");
        }
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> null, workerExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0))).thenAcceptAsync(noResult -> {}, mainExecutor);
    }

    protected void onNormalReload(ResourceManager manager) {
    }

    protected void onEarlyReload(EarlyPackReloadEvent event) {
        if (event.type() == ((DynamicResourcePack)this.dynamicPack).packType) {
            try {
                this.reloadResources(event.manager());
            }
            catch (Exception e) {
                Moonlight.LOGGER.error("An error occurred while trying to generate dynamic assets for {}:", this.dynamicPack, (Object)e);
            }
        }
    }

    protected final void reloadResources(ResourceManager manager) {
        Stopwatch watch = Stopwatch.createStarted();
        boolean resourcePackSupport = this.dependsOnLoadedPacks();
        if (!this.hasBeenInitialized) {
            this.hasBeenInitialized = true;
            ((DynamicResourcePack)this.dynamicPack).addToPersistent = true;
            this.generateStaticAssetsOnStartup(manager);
            T t = this.dynamicPack;
            if (t instanceof DynamicTexturePack) {
                DynamicTexturePack tp = (DynamicTexturePack)t;
                tp.addPackLogo();
            }
            if (!resourcePackSupport) {
                PackRepository pack = this.getRepository();
                if (pack != null) {
                    VanillaResourceManager vanillaManager = new VanillaResourceManager(pack);
                    this.regenerateDynamicAssets(vanillaManager);
                    vanillaManager.close();
                } else {
                    this.regenerateDynamicAssets(manager);
                }
            }
            ((DynamicResourcePack)this.dynamicPack).addToPersistent = false;
        }
        if (resourcePackSupport) {
            this.regenerateDynamicAssets(manager);
        }
        this.getLogger().info("Generated runtime {} for pack {} in: {} ms" + (((DynamicResourcePack)this.dynamicPack).generateDebugResources ? " (debug resource dump on)" : ""), (Object)((DynamicResourcePack)this.dynamicPack).getPackType(), (Object)((DynamicResourcePack)this.dynamicPack).m_8017_(), (Object)watch.elapsed().toMillis());
    }

    @Nullable
    protected abstract PackRepository getRepository();

    public boolean alreadyHasAssetAtLocation(ResourceManager manager, ResourceLocation res, ResType type) {
        return this.alreadyHasAssetAtLocation(manager, type.getPath(res));
    }

    public boolean alreadyHasAssetAtLocation(ResourceManager manager, ResourceLocation res) {
        Optional resource = manager.m_213713_(res);
        return resource.filter(value -> !value.m_215506_().equals(((DynamicResourcePack)this.dynamicPack).m_8017_())).isPresent();
    }

    public void addSimilarJsonResource(ResourceManager manager, StaticResource resource, String keyword, String replaceWith) throws NoSuchElementException {
        this.addSimilarJsonResource(manager, resource, s -> s.replace(keyword, replaceWith));
    }

    public void addSimilarJsonResource(ResourceManager manager, StaticResource resource, Function<String, String> textTransform) throws NoSuchElementException {
        this.addSimilarJsonResource(manager, resource, textTransform, textTransform);
    }

    public void addSimilarJsonResource(ResourceManager manager, StaticResource resource, Function<String, String> textTransform, Function<String, String> pathTransform) throws NoSuchElementException {
        ResourceLocation fullPath = resource.location;
        StringBuilder builder = new StringBuilder();
        String[] partial = fullPath.m_135815_().split("/");
        for (int i = 0; i < partial.length; ++i) {
            if (i != 0) {
                builder.append("/");
            }
            if (i == partial.length - 1) {
                builder.append(pathTransform.apply(partial[i]));
                continue;
            }
            builder.append(partial[i]);
        }
        ResourceLocation newRes = new ResourceLocation(((DynamicResourcePack)this.dynamicPack).resourcePackName.m_135827_(), builder.toString());
        if (!this.alreadyHasAssetAtLocation(manager, newRes)) {
            String fullText = new String(resource.data, StandardCharsets.UTF_8);
            fullText = textTransform.apply(fullText);
            ((DynamicResourcePack)this.dynamicPack).addBytes(newRes, fullText.getBytes());
        }
    }

    public void addResourceIfNotPresent(ResourceManager manager, StaticResource resource) {
        if (!this.alreadyHasAssetAtLocation(manager, resource.location)) {
            ((DynamicResourcePack)this.dynamicPack).addResource(resource);
        }
    }
}

