/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.client.recipebook.screen.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.cristelknight.doapi.DoApiRL;
import de.cristelknight.doapi.client.recipebook.handler.AbstractPrivateRecipeScreenHandler;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PrivateAnimatedResultButton
extends AbstractWidget {
    private static final ResourceLocation BACKGROUND_TEXTURE = new DoApiRL("textures/gui/recipe_book.png");
    private AbstractPrivateRecipeScreenHandler craftingScreenHandler;
    private Recipe<?> recipe;
    private float bounce;

    public PrivateAnimatedResultButton() {
        super(0, 0, 25, 25, CommonComponents.f_237098_);
    }

    public void showResultCollection(Recipe<?> recipe, AbstractPrivateRecipeScreenHandler craftingScreenHandler) {
        this.recipe = recipe;
        this.craftingScreenHandler = craftingScreenHandler;
    }

    public Recipe<?> getRecipe() {
        return this.recipe;
    }

    public void setPos(int x, int y) {
        this.f_93620_ = x;
        this.f_93621_ = y;
    }

    public void m_6303_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        Minecraft minecraftClient = Minecraft.m_91087_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND_TEXTURE);
        int i = 29;
        if (!this.craftingScreenHandler.hasIngredient(this.recipe)) {
            i += 25;
        }
        int j = 206;
        boolean bl = this.bounce > 0.0f;
        PoseStack matrixStack = RenderSystem.m_157191_();
        if (bl) {
            float f = 1.0f + 0.1f * (float)Math.sin(this.bounce / 15.0f * (float)Math.PI);
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)(this.f_93620_ + 8), (double)(this.f_93621_ + 12), 0.0);
            matrixStack.m_85841_(f, f, 1.0f);
            matrixStack.m_85837_((double)(-(this.f_93620_ + 8)), (double)(-(this.f_93621_ + 12)), 0.0);
            RenderSystem.m_157182_();
            this.bounce -= delta;
        }
        this.m_93228_(matrices, this.f_93620_, this.f_93621_, i, j, this.f_93618_, this.f_93619_);
        Recipe<?> recipe = this.getResult();
        int k = 4;
        minecraftClient.m_91291_().m_115218_(recipe.m_8043_(), this.f_93620_ + k, this.f_93621_ + k);
        if (bl) {
            matrixStack.m_85849_();
            RenderSystem.m_157182_();
        }
    }

    private Recipe<?> getResult() {
        return this.recipe;
    }

    public boolean hasResult() {
        return this.getResult() != null;
    }

    public Recipe<?> currentRecipe() {
        return this.getResult();
    }

    protected boolean m_7972_(int button) {
        return button == 0 || button == 1;
    }

    public List<Component> getTooltip(Screen screen) {
        ItemStack itemStack = this.getResult().m_8043_();
        return Lists.newArrayList((Iterable)screen.m_96555_(itemStack));
    }

    public void m_142291_(NarrationElementOutput builder) {
        ItemStack itemStack = this.getResult().m_8043_();
        builder.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237110_((String)"narration.recipe", (Object[])new Object[]{itemStack.m_41786_()}));
        builder.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.button.usage.hovered"));
    }

    public int m_5711_() {
        return 25;
    }
}

