/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.core.init;

import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import xyz.apex.forge.apexcore.lib.item.ItemGroupCategory;
import xyz.apex.forge.apexcore.lib.item.ItemGroupCategoryManager;
import xyz.apex.forge.commonality.tags.ItemTags;

public final class ACItemGroupCategories {
    public static final ItemGroupCategory ENCHANTED_BOOKS = ItemGroupCategory.builder("enchanted_books").cycleIcons().predicate(stack -> stack.m_41720_() == Items.f_42690_).build();
    public static final ItemGroupCategory TOOLS = ItemGroupCategory.builder("tools").cycleIcons().predicate(stack -> stack.m_41720_() instanceof DiggerItem).build();
    public static final ItemGroupCategory WEAPONS = ItemGroupCategory.builder("weapons").cycleIcons().predicate(stack -> {
        Item item = stack.m_41720_();
        if (item instanceof SwordItem) {
            return true;
        }
        if (item instanceof CrossbowItem) {
            return true;
        }
        if (item instanceof BowItem) {
            return true;
        }
        if (item instanceof AxeItem) {
            return true;
        }
        if (item instanceof FlintAndSteelItem) {
            return true;
        }
        return item instanceof TridentItem;
    }).build();
    public static final ItemGroupCategory ARMOR = ItemGroupCategory.builder("armor").cycleIcons().predicate(stack -> stack.m_41720_() instanceof ArmorItem).build();
    public static final ItemGroupCategory STAIRS = ItemGroupCategory.builder("stairs").cycleIcons().tagged((TagKey<Item>)ItemTags.Vanilla.STAIRS).build();
    public static final ItemGroupCategory SLABS = ItemGroupCategory.builder("slabs").cycleIcons().tagged((TagKey<Item>)ItemTags.Vanilla.SLABS).build();
    public static final ItemGroupCategory ORES = ItemGroupCategory.builder("ores").cycleIcons().tagged((TagKey<Item>)ItemTags.Forge.ORES).build();
    public static final ItemGroupCategory STORAGE_BLOCKS = ItemGroupCategory.builder("storage_blocks").cycleIcons().tagged((TagKey<Item>)ItemTags.Forge.STORAGE_BLOCKS).build();
    public static final ItemGroupCategory WOOLS = ItemGroupCategory.builder("wool").cycleIcons().tagged((TagKey<Item>)ItemTags.Vanilla.WOOL).build();
    public static final ItemGroupCategory LOGS = ItemGroupCategory.builder("logs").cycleIcons().tagged((TagKey<Item>)ItemTags.Vanilla.LOGS).build();
    private static boolean enabled = false;

    public static void enable() {
        if (enabled) {
            return;
        }
        ItemGroupCategoryManager manager = ItemGroupCategoryManager.getInstance(CreativeModeTab.f_40757_);
        manager.addCategories(ENCHANTED_BOOKS, WEAPONS, ARMOR);
        manager = ItemGroupCategoryManager.getInstance(CreativeModeTab.f_40756_);
        manager.addCategories(ENCHANTED_BOOKS, WEAPONS, TOOLS);
        manager = ItemGroupCategoryManager.getInstance(CreativeModeTab.f_40749_);
        manager.addCategories(STAIRS, SLABS, ORES, STORAGE_BLOCKS, WOOLS, LOGS);
        enabled = true;
    }
}

