/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.registries;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.DynamicOps;
import corgitaco.corgilib.platform.ModPlatform;
import corgitaco.corgilib.serialization.jankson.JanksonJsonOps;
import corgitaco.corgilib.serialization.jankson.JanksonUtil;
import corgitaco.corgilib.shadow.blue.endless.jankson.JsonElement;
import it.unimi.dsi.fastutil.Function;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;

public class WorldRegistryExportCommand {
    public static final Map<String, String> COMMENTS = (Map)Util.m_137469_(new HashMap(), map -> {});

    public static LiteralArgumentBuilder<CommandSourceStack> registerWorldRegistryExportCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        return WorldRegistryExportCommand.registerWorldRegistryExportCommand(dispatcher, "worldRegistryExport");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> registerWorldRegistryExportCommand(CommandDispatcher<CommandSourceStack> dispatcher, String commandString) {
        Function withComments = cs -> (Boolean)((CommandContext)cs).getArgument("With comments?", Boolean.class);
        Function builtin = cs -> (Boolean)((CommandContext)cs).getArgument("Generate Built In Registries?", Boolean.class);
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)commandString).requires(stack -> stack.m_6761_(4))).executes(cs -> WorldRegistryExportCommand.generateWorldRegistryExport(true, false, (CommandContext<CommandSourceStack>)cs))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"With comments?", (ArgumentType)BoolArgumentType.bool()).executes(cs -> WorldRegistryExportCommand.generateWorldRegistryExport((Boolean)withComments.apply((Object)cs), false, (CommandContext<CommandSourceStack>)cs))).then(Commands.m_82129_((String)"Generate Built In Registries?", (ArgumentType)BoolArgumentType.bool()).executes(cs -> WorldRegistryExportCommand.generateWorldRegistryExport((Boolean)withComments.apply((Object)cs), (Boolean)builtin.apply((Object)cs), (CommandContext<CommandSourceStack>)cs))));
    }

    public static int generateWorldRegistryExport(boolean withComments, boolean builtin, CommandContext<CommandSourceStack> commandSource) {
        CommandSourceStack source = (CommandSourceStack)commandSource.getSource();
        if (!source.m_81377_().m_129792_() || source.m_81377_().m_7416_() > 1) {
            source.m_81352_((Component)Component.m_237115_((String)"corgilib.worldRegistryExport.singleplayer").m_130940_(ChatFormatting.RED));
            return 0;
        }
        Path finalExportPath = ModPlatform.PLATFORM.modConfigDir().resolve("world_registry_export").resolve(builtin ? "builtin" : "world").resolve("data");
        MutableComponent exportFileComponent = Component.m_237113_((String)finalExportPath.toString()).m_130940_(ChatFormatting.UNDERLINE).m_130938_(text -> text.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.AQUA)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, finalExportPath.toString())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"corgilib.clickevent.hovertext"))));
        if (finalExportPath.toFile().exists()) {
            source.m_81352_((Component)Component.m_237110_((String)"corgilib.worldRegistryExport.exists", (Object[])new Object[]{exportFileComponent}).m_130940_(ChatFormatting.RED));
            return 0;
        }
        source.m_81354_((Component)Component.m_237115_((String)"corgilib.worldRegistryExport.starting").m_130940_(ChatFormatting.YELLOW), true);
        try {
            WorldRegistryExportCommand.generateFiles(builtin, source, finalExportPath, withComments);
            WorldRegistryExportCommand.createPackMCMeta(finalExportPath.getParent(), builtin);
            source.m_81354_((Component)Component.m_237110_((String)"corgilib.worldRegistryExport.success", (Object[])new Object[]{exportFileComponent}).m_130940_(ChatFormatting.GREEN), true);
            return 1;
        }
        catch (IOException e) {
            source.m_81352_((Component)Component.m_237115_((String)"corgilib.worldRegistryExport.failed"));
            e.printStackTrace();
            return 0;
        }
    }

    private static void generateFiles(boolean builtin, CommandSourceStack source, Path exportPath, boolean withComments) throws IOException {
        Files.createDirectories(exportPath, new FileAttribute[0]);
        RegistryAccess.Writable registry = builtin ? RegistryAccess.m_206197_() : source.m_81372_().m_5962_();
        RegistryOps ops = RegistryOps.m_206821_((DynamicOps)JanksonJsonOps.INSTANCE, (RegistryAccess)registry);
        for (RegistryAccess.RegistryData knownRegistry : RegistryAccess.m_194613_()) {
            WorldRegistryExportCommand.dumpRegistryCap(exportPath, (RegistryAccess)registry, (DynamicOps<JsonElement>)ops, knownRegistry, withComments);
        }
    }

    private static <T> void dumpRegistryCap(Path root, RegistryAccess registryAccess, DynamicOps<JsonElement> ops, RegistryAccess.RegistryData<T> data, boolean withComments) {
        ResourceKey resourceKey = data.f_123101_();
        Registry registry = registryAccess.m_206191_(resourceKey);
        for (Map.Entry resourceKeyTEntry : registry.m_6579_()) {
            ResourceKey resourceKeyTEntryKey = (ResourceKey)resourceKeyTEntry.getKey();
            Path resolve = root.resolve(resourceKeyTEntryKey.m_135782_().m_135827_());
            String resourceKeyNamespace = resourceKey.m_135782_().m_135827_();
            if (ModPlatform.PLATFORM.getPlatformName().equalsIgnoreCase("Forge") && !resourceKeyNamespace.equalsIgnoreCase("minecraft")) {
                resolve = resolve.resolve(resourceKeyNamespace);
            }
            Path path = resolve.resolve(resourceKey.m_135782_().m_135815_()).resolve(resourceKeyTEntryKey.m_135782_().m_135815_() + ".json");
            try {
                Optional jsonElement = data.f_123102_().encodeStart(ops, resourceKeyTEntry.getValue()).result();
                if (!jsonElement.isPresent()) continue;
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                JsonElement loadedElement = (JsonElement)jsonElement.get();
                if (!withComments) continue;
                loadedElement = JanksonUtil.addCommentsAndAlphabeticallySortRecursively(COMMENTS, loadedElement, "", true);
                Files.write(path, loadedElement.toJson(JanksonUtil.JSON_GRAMMAR).getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void createPackMCMeta(Path path, boolean builtIn) throws IOException {
        String fileString = "{\n\t\"pack\":{\n\t\t\"pack_format\": 10,\n\t\t\"description\": \" Generated world gen datapack from " + (builtIn ? "built in registries" : "current world registries") + ".\"\n\t}\n}\n";
        Files.write(path.resolve("pack.mcmeta"), fileString.getBytes(), new OpenOption[0]);
    }
}

