/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.model;

import fuzs.betteranimationscollection.client.model.KneesModel;
import it.unimi.dsi.fastutil.Pair;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;

public class HumanoidKneesModel<T extends LivingEntity>
extends HumanoidModel<T>
implements KneesModel {
    private final ModelPart rightShin;
    private final ModelPart leftShin;

    public HumanoidKneesModel(ModelPart modelPart) {
        super(modelPart);
        ModelPart rightLeg = modelPart.m_171324_("right_leg");
        this.rightShin = rightLeg.m_171324_("right_shin");
        ModelPart leftLeg = modelPart.m_171324_("left_leg");
        this.leftShin = leftLeg.m_171324_("left_shin");
    }

    public static MeshDefinition createAnimatedMesh(CubeDeformation cubeDeformation, float offsetY) {
        MeshDefinition meshDefinition = HumanoidModel.m_170681_((CubeDeformation)cubeDeformation, (float)offsetY);
        PartDefinition partDefinition = meshDefinition.m_171576_();
        Pair<CubeListBuilder, PartPose> rightLeg = HumanoidKneesModel.createShin(0, 16, -1.9f, 0.0f, 0.0f, false, cubeDeformation);
        Pair<CubeListBuilder, PartPose> leftLeg = HumanoidKneesModel.createShin(0, 16, 1.9f, 0.0f, 0.0f, true, cubeDeformation);
        Pair<CubeListBuilder, PartPose> rightShin = HumanoidKneesModel.createShin(0, 22, 0.0f, -6.0f, -2.0f, false, cubeDeformation);
        Pair<CubeListBuilder, PartPose> leftShin = HumanoidKneesModel.createShin(0, 22, 0.0f, -6.0f, -2.0f, true, cubeDeformation);
        PartDefinition partDefinition1 = partDefinition.m_171599_("right_leg", (CubeListBuilder)rightLeg.left(), (PartPose)rightLeg.right());
        PartDefinition partDefinition2 = partDefinition.m_171599_("left_leg", (CubeListBuilder)leftLeg.left(), (PartPose)leftLeg.right());
        partDefinition1.m_171599_("right_shin", (CubeListBuilder)rightShin.left(), (PartPose)rightShin.right());
        partDefinition2.m_171599_("left_shin", (CubeListBuilder)leftShin.left(), (PartPose)leftShin.right());
        return meshDefinition;
    }

    public static Pair<CubeListBuilder, PartPose> createShin(int textureX, int textureY, float offsetX, float offsetY, float offsetZ, boolean mirror, CubeDeformation cubeDeformation) {
        CubeListBuilder cubeListBuilder = CubeListBuilder.m_171558_().m_171514_(textureX, textureY);
        if (mirror) {
            cubeListBuilder.m_171480_();
        }
        cubeListBuilder.m_171488_(-2.0f, 0.0f, -2.0f - offsetZ, 4.0f, 6.0f, 4.0f, cubeDeformation);
        return Pair.of((Object)cubeListBuilder, (Object)PartPose.m_171419_((float)offsetX, (float)(12.0f + offsetY), (float)offsetZ));
    }

    public void m_6973_(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        KneesModel.setupAnim(this, entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    public void m_102872_(HumanoidModel<T> model) {
        super.m_102872_(model);
        KneesModel.copyPropertiesTo(this, model);
    }

    @Override
    public ModelPart rightShin() {
        return this.rightShin;
    }

    @Override
    public ModelPart leftShin() {
        return this.leftShin;
    }
}

