/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.handler;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fuzs.betteranimationscollection.BetterAnimationsCollection;
import fuzs.betteranimationscollection.config.ClientConfig;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEventListener;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RemoteSoundHandler {
    public static final RemoteSoundHandler INSTANCE = new RemoteSoundHandler();
    private static final int MAX_SOUND_ANIMATION_TIME = 20;
    private final Map<ResourceLocation, Class<? extends Mob>> ambientSounds = Maps.newConcurrentMap();
    private final Set<Class<? extends Mob>> noisyEntities = Sets.newConcurrentHashSet();
    private final Set<Class<? extends Mob>> attackableEntities = Sets.newHashSet();
    private final SoundDetectionListener soundListener = new SoundDetectionListener();

    public Optional<Unit> onLivingTick(LivingEntity entity) {
        this.soundListener.ensureInitialized();
        if (!entity.f_19853_.f_46443_ || !(entity instanceof Mob)) {
            return Optional.empty();
        }
        Mob mob = (Mob)entity;
        Stream.concat(this.noisyEntities.stream(), this.attackableEntities.stream()).forEach(clazz -> {
            if (clazz.isAssignableFrom(entity.getClass()) && mob.f_21363_ >= 0) {
                mob.f_21363_ = -mob.m_8100_() + 20;
            }
        });
        for (Class<? extends Mob> clazz2 : this.attackableEntities) {
            if (!clazz2.isAssignableFrom(entity.getClass()) || mob.f_20917_ <= 0 || mob.f_20916_ != mob.f_20917_) continue;
            mob.f_21363_ = -mob.m_8100_();
        }
        return Optional.empty();
    }

    public void addAmbientSounds(Class<? extends Mob> entityClazz, Collection<SoundEvent> soundEvents) {
        this.noisyEntities.add(entityClazz);
        for (SoundEvent soundEvent : soundEvents) {
            this.ambientSounds.put(soundEvent.m_11660_(), entityClazz);
        }
    }

    public void removeAmbientSounds(Class<? extends Mob> entityClazz) {
        this.ambientSounds.values().removeIf(clazz -> clazz.equals(entityClazz));
    }

    public void addAttackableEntity(Class<? extends Mob> entityClazz) {
        this.attackableEntities.add(entityClazz);
    }

    private class SoundDetectionListener
    implements SoundEventListener {
        private boolean initialized;

        private SoundDetectionListener() {
        }

        public void ensureInitialized() {
            if (!this.initialized) {
                Minecraft.m_91087_().m_91106_().m_120374_((SoundEventListener)this);
                this.initialized = true;
            }
        }

        public void m_6985_(SoundInstance soundIn, WeighedSoundEvents accessor) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return;
            }
            Class<? extends Mob> entityClazz = RemoteSoundHandler.this.ambientSounds.get(soundIn.m_7904_());
            if (entityClazz != null) {
                Vec3 center = new Vec3(soundIn.m_7772_() + 0.0625, soundIn.m_7780_() + 0.0625, soundIn.m_7778_() + 0.0625);
                double soundDetectionRange = ((ClientConfig)BetterAnimationsCollection.CONFIG.get(ClientConfig.class)).soundDetectionRange;
                AABB axisAlignedBB = new AABB(center, center).m_82400_(soundDetectionRange + 0.0625);
                List entities = level.m_45976_(entityClazz, axisAlignedBB);
                entities.stream().min((o1, o2) -> (int)Math.signum(o1.m_20182_().m_82554_(center) - o2.m_20182_().m_82554_(center))).ifPresent(entity -> {
                    entity.f_21363_ = -entity.m_8100_();
                });
            }
        }
    }
}

