/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.element;

import com.google.common.collect.Lists;
import fuzs.betteranimationscollection.client.element.ModelElementBase;
import fuzs.betteranimationscollection.client.handler.RemoteSoundHandler;
import fuzs.puzzleslib.config.ValueCallback;
import fuzs.puzzleslib.config.core.AbstractConfigBuilder;
import fuzs.puzzleslib.config.serialization.EntryCollectionBuilder;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Mob;

public abstract class SoundDetectionElement
extends ModelElementBase {
    private final Class<? extends Mob> mobClazz;
    private final SoundEvent[] sounds;

    public SoundDetectionElement(Class<? extends Mob> mobClazz, SoundEvent ... sounds) {
        this.mobClazz = mobClazz;
        this.sounds = sounds;
        RemoteSoundHandler.INSTANCE.addAmbientSounds(mobClazz, Lists.newArrayList((Object[])sounds));
    }

    @Override
    public void setupModelConfig(AbstractConfigBuilder builder, ValueCallback callback) {
        callback.accept((Supplier)builder.comment(new String[]{"Mob sounds to play a unique animation for.", "Useful for adding support for modded mob variants which have different sounds from their vanilla counterparts.", "Format for every entry is \"<namespace>:<path>\". Path may use asterisk as wildcard parameter. Tags are not supported."}).define("mob_sounds", Stream.of(this.sounds).map(arg_0 -> ((Registry)Registry.f_122821_).m_7981_(arg_0)).filter(Objects::nonNull).map(ResourceLocation::toString).collect(Collectors.toList())), v -> {
            RemoteSoundHandler.INSTANCE.removeAmbientSounds(this.mobClazz);
            Set soundEvents = EntryCollectionBuilder.of((ResourceKey)Registry.f_122898_).buildSet(v);
            RemoteSoundHandler.INSTANCE.addAmbientSounds(this.mobClazz, soundEvents);
        });
    }
}

