/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.TooltipAccessor;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import nx.pingwheel.common.ClientGlobal;
import nx.pingwheel.common.config.ClientConfig;
import nx.pingwheel.common.helper.LanguageUtils;
import nx.pingwheel.common.helper.OptionUtils;

public class SettingsScreen
extends Screen {
    private final ClientConfig config = ClientGlobal.ConfigHandler.getConfig();
    private Screen parent;
    private OptionsList list;
    private EditBox channelTextField;

    public SettingsScreen() {
        super((Component)LanguageUtils.settings("title").get(new Object[0]));
    }

    public SettingsScreen(Screen parent) {
        this();
        this.parent = parent;
    }

    public void m_86600_() {
        this.channelTextField.m_94120_();
    }

    protected void m_7856_() {
        this.list = new OptionsList(this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 25);
        OptionInstance<Integer> pingVolumeOption = this.getPingVolumeOption();
        OptionInstance<Integer> pingDurationOption = this.getPingDurationOption();
        this.list.m_232530_(pingVolumeOption, pingDurationOption);
        OptionInstance<Integer> pingDistanceOption = this.getPingDistanceOption();
        OptionInstance<Float> correctionPeriodOption = this.getCorrectionPeriodOption();
        this.list.m_232530_(pingDistanceOption, correctionPeriodOption);
        OptionInstance<Boolean> itemIconsVisibleOption = this.getItemIconsVisibleOption();
        OptionInstance<Boolean> directionIndicatorVisibleOption = this.getDirectionIndicatorVisibleOption();
        this.list.m_232530_(itemIconsVisibleOption, directionIndicatorVisibleOption);
        OptionInstance<Boolean> nameLabelForcedOption = this.getNameLabelForcedOption();
        OptionInstance<Integer> pingSizeOption = this.getPingSizeOption();
        this.list.m_232530_(nameLabelForcedOption, pingSizeOption);
        this.channelTextField = new EditBox(this.f_96547_, this.f_96543_ / 2 - 100, 160, 200, 20, (Component)Component.m_237119_());
        this.channelTextField.m_94199_(128);
        this.channelTextField.m_94144_(this.config.getChannel());
        this.channelTextField.m_94151_(this.config::setChannel);
        this.m_7787_((GuiEventListener)this.channelTextField);
        this.m_7787_((GuiEventListener)this.list);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ - 27, 200, 20, CommonComponents.f_130655_, button -> this.m_7379_()));
    }

    public void m_7379_() {
        ClientGlobal.ConfigHandler.save();
        if (this.parent != null && this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        } else {
            super.m_7379_();
        }
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.m_7333_(matrices);
        this.list.m_6305_(matrices, mouseX, mouseY, delta);
        SettingsScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)20, (int)0xFFFFFF);
        SettingsScreen.m_93243_((PoseStack)matrices, (Font)this.f_96547_, (Component)LanguageUtils.settings("channel").get(new Object[0]), (int)(this.f_96543_ / 2 - 100), (int)(this.channelTextField.f_93621_ - 12), (int)0xA0A0A0);
        this.channelTextField.m_6305_(matrices, mouseX, mouseY, delta);
        super.m_6305_(matrices, mouseX, mouseY, delta);
        List tooltipLines = SettingsScreen.getHoveredButtonTooltip(this.list, mouseX, mouseY);
        if (tooltipLines.isEmpty() && this.channelTextField.m_198029_() && !this.channelTextField.m_93696_()) {
            tooltipLines = this.f_96547_.m_92923_((FormattedText)LanguageUtils.settings("channel.tooltip").get(new Object[0]), 140);
        }
        this.m_96617_(matrices, tooltipLines, mouseX, mouseY);
    }

    private static List<FormattedCharSequence> getHoveredButtonTooltip(OptionsList buttonList, int mouseX, int mouseY) {
        TooltipAccessor orderableTooltip = buttonList.m_94480_((double)mouseX, (double)mouseY).orElse(null);
        if (orderableTooltip != null) {
            return orderableTooltip.m_141932_();
        }
        return Collections.emptyList();
    }

    private OptionInstance<Integer> getPingVolumeOption() {
        LanguageUtils.LanguageWrapper text = LanguageUtils.settings("pingVolume");
        return OptionUtils.ofInt(text.key(), 0, 100, 1, value -> {
            if (value == 0) {
                return text.get(CommonComponents.f_130654_);
            }
            return text.get(LanguageUtils.UNIT_PERCENT.get(value));
        }, this.config::getPingVolume, this.config::setPingVolume);
    }

    private OptionInstance<Integer> getPingDurationOption() {
        LanguageUtils.LanguageWrapper text = LanguageUtils.settings("pingDuration");
        return OptionUtils.ofInt(text.key(), 1, 60, 1, value -> {
            if (value >= 60) {
                return text.get(LanguageUtils.SYMBOL_INFINITE);
            }
            return text.get(LanguageUtils.UNIT_SECONDS.get(value));
        }, this.config::getPingDuration, this.config::setPingDuration);
    }

    private OptionInstance<Integer> getPingDistanceOption() {
        LanguageUtils.LanguageWrapper text = LanguageUtils.settings("pingDistance");
        return OptionUtils.ofInt(text.key(), 0, 2048, 16, value -> {
            if (value == 0) {
                return text.get(LanguageUtils.VALUE_HIDDEN);
            }
            if (value >= 2048) {
                return text.get(LanguageUtils.SYMBOL_INFINITE);
            }
            return text.get(LanguageUtils.UNIT_METERS.get(value));
        }, this.config::getPingDistance, this.config::setPingDistance);
    }

    private OptionInstance<Float> getCorrectionPeriodOption() {
        LanguageUtils.LanguageWrapper text = LanguageUtils.settings("correctionPeriod");
        return OptionUtils.ofFloat(text.key(), 0.1f, 5.0f, 0.1f, value -> {
            if (value.floatValue() >= 5.0f) {
                return text.get(LanguageUtils.SYMBOL_INFINITE);
            }
            return text.get(LanguageUtils.UNIT_SECONDS.get("%.1f".formatted(value)));
        }, this.config::getCorrectionPeriod, this.config::setCorrectionPeriod);
    }

    private OptionInstance<Boolean> getItemIconsVisibleOption() {
        return OptionUtils.ofBool(LanguageUtils.settings("itemIconVisible").key(), this.config::isItemIconVisible, this.config::setItemIconVisible);
    }

    private OptionInstance<Boolean> getDirectionIndicatorVisibleOption() {
        return OptionUtils.ofBool(LanguageUtils.settings("directionIndicatorVisible").key(), this.config::isDirectionIndicatorVisible, this.config::setDirectionIndicatorVisible);
    }

    private OptionInstance<Boolean> getNameLabelForcedOption() {
        return OptionUtils.ofBool(LanguageUtils.settings("nameLabelForced").key(), this.config::isNameLabelForced, this.config::setNameLabelForced);
    }

    private OptionInstance<Integer> getPingSizeOption() {
        LanguageUtils.LanguageWrapper text = LanguageUtils.settings("pingSize");
        return OptionUtils.ofInt(text.key(), 40, 300, 10, value -> text.get(LanguageUtils.UNIT_PERCENT.get(value)), this.config::getPingSize, this.config::setPingSize);
    }
}

