/*
 * Decompiled with CFR 0.152.
 */
package snownee.passablefoliage.mixin;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeBlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import snownee.passablefoliage.PassableFoliage;
import snownee.passablefoliage.PassableFoliageCommonConfig;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
public class BlockStateMixin
implements IForgeBlockState {
    @Shadow
    protected BlockBehaviour.BlockStateBase.Cache f_60593_;

    private BlockState self() {
        return (BlockState)this;
    }

    @Inject(at={@At(value="HEAD")}, method={"getCollisionShape(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/phys/shapes/VoxelShape;"}, cancellable=true)
    private void pfoliage_getCollisionShape(BlockGetter worldIn, BlockPos pos, CallbackInfoReturnable<VoxelShape> info) {
        if (this.f_60593_ == null && PassableFoliage.isPassable(this.self())) {
            info.setReturnValue((Object)Shapes.m_83040_());
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getCollisionShape(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;"}, cancellable=true)
    private void pfoliage_getCollisionShape(BlockGetter worldIn, BlockPos pos, CollisionContext context, CallbackInfoReturnable<VoxelShape> info) {
        if (PassableFoliage.isPassable(this.self())) {
            Entity entity = null;
            if (context instanceof EntityCollisionContext) {
                entity = ((EntityCollisionContext)context).m_193113_();
            }
            if (PassableFoliageCommonConfig.playerOnly && !(entity instanceof Player)) {
                return;
            }
            if (entity instanceof LivingEntity && PassableFoliage.hasLeafWalker((LivingEntity)entity)) {
                if (context.m_6226_() || entity.m_20183_().m_123342_() <= pos.m_123342_()) {
                    info.setReturnValue((Object)Shapes.m_83040_());
                }
                return;
            }
            info.setReturnValue((Object)Shapes.m_83040_());
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getVisualShape"}, cancellable=true)
    private void pfoliage_getVisualShape(BlockGetter p_60772_, BlockPos p_60773_, CollisionContext p_60774_, CallbackInfoReturnable<VoxelShape> ci) {
        if (PassableFoliage.isPassable(this.self())) {
            ci.setReturnValue((Object)Shapes.m_83040_());
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isCollisionShapeFullBlock"}, cancellable=true)
    private void pfoliage_isCollisionShapeFullBlock(BlockGetter blockReaderIn, BlockPos blockPosIn, CallbackInfoReturnable<Boolean> info) {
        if (this.f_60593_ == null && PassableFoliage.isPassable(this.self())) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"entityInside"})
    private void pfoliage_entityInside(Level worldIn, BlockPos pos, Entity entityIn, CallbackInfo info) {
        if (PassableFoliage.isPassable(this.self())) {
            PassableFoliage.onEntityCollidedWithLeaves(worldIn, pos, entityIn);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @Inject(at={@At(value="HEAD")}, method={"getShadeBrightness"}, cancellable=true)
    private void pfoliage_getShadeBrightness(BlockGetter reader, BlockPos pos, CallbackInfoReturnable<Float> info) {
        if (PassableFoliage.isPassable(this.self())) {
            info.setReturnValue((Object)Float.valueOf(0.2f));
        }
    }

    public BlockPathTypes getBlockPathType(BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        if (!PassableFoliageCommonConfig.playerOnly && PassableFoliageCommonConfig.modifyPathFinding && PassableFoliage.isPassable(this.self()) && (entity == null || !PassableFoliage.hasLeafWalker((LivingEntity)entity))) {
            return BlockPathTypes.OPEN;
        }
        return this.self().m_60734_().getBlockPathType(this.self(), world, pos, entity);
    }

    @Inject(at={@At(value="HEAD")}, method={"isSuffocating"}, cancellable=true)
    private void pfoliage_isSuffocating(BlockGetter level, BlockPos pos, CallbackInfoReturnable<Boolean> ci) {
        if (PassableFoliage.isPassable(this.self())) {
            ci.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isViewBlocking"}, cancellable=true)
    private void pfoliage_isViewBlocking(BlockGetter level, BlockPos pos, CallbackInfoReturnable<Boolean> ci) {
        if (PassableFoliageCommonConfig.alwaysNotViewBlocking && PassableFoliage.isPassable(this.self())) {
            ci.setReturnValue((Object)false);
        }
    }
}

