/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public record QuantifiedIngredient(Ingredient ingredient, int quantity) implements Predicate<ItemStack>
{
    public QuantifiedIngredient(Ingredient ingredient, int quantity) {
        this.ingredient = Objects.requireNonNull(ingredient);
        this.quantity = Math.max(0, quantity);
    }

    public QuantifiedIngredient(JsonObject obj) {
        this(Ingredient.m_43917_((JsonElement)obj.get("ingredient")), Math.max(1, GsonHelper.m_13824_((JsonObject)obj, (String)"quantity", (int)1)));
    }

    public static QuantifiedIngredient read(FriendlyByteBuf buffer) {
        return new QuantifiedIngredient(Ingredient.m_43940_((FriendlyByteBuf)buffer), buffer.m_130242_());
    }

    @Override
    public boolean test(ItemStack itemStack) {
        return this.ingredient.test(itemStack);
    }

    public JsonElement serialize() {
        JsonObject obj = new JsonObject();
        obj.add("ingredient", this.ingredient.m_43942_());
        if (this.quantity != 1) {
            obj.addProperty("quantity", (Number)this.quantity);
        }
        return obj;
    }

    public void write(FriendlyByteBuf buffer) {
        this.ingredient.m_43923_(buffer);
        buffer.m_130130_(this.quantity);
    }
}

