/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.event;

import com.mojang.blaze3d.platform.InputConstants;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import tictim.paraglider.ModCfg;
import tictim.paraglider.capabilities.PlayerMovement;
import tictim.paraglider.client.screen.ParagliderSettingScreen;
import tictim.paraglider.client.screen.StatueBargainScreen;

@Mod.EventBusSubscriber(modid="paraglider", value={Dist.CLIENT})
public final class ParagliderClientEventHandler {
    private static KeyMapping paragliderSettingsKey;
    private static final DecimalFormat PERCENTAGE;

    private ParagliderClientEventHandler() {
    }

    public static KeyMapping paragliderSettingsKey() {
        return paragliderSettingsKey;
    }

    @SubscribeEvent
    public static void onOffHandRender(RenderHandEvent event) {
        if (event.getHand() != InteractionHand.OFF_HAND) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        PlayerMovement m = PlayerMovement.of((ICapabilityProvider)player);
        if (m != null && m.isParagliding()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void customizeDebugText(CustomizeGuiOverlayEvent.DebugText event) {
        PlayerMovement h;
        LocalPlayer p;
        if (ModCfg.debugPlayerMovement() && (p = Minecraft.m_91087_().f_91074_) != null && (h = PlayerMovement.of((ICapabilityProvider)p)) != null) {
            ArrayList right = event.getRight();
            ArrayList<Object> arr = new ArrayList<Object>();
            arr.add("State: " + h.getState());
            arr.add((Serializable)(h.isDepleted() ? ChatFormatting.RED : "") + "Stamina: " + h.getStamina() + " / " + h.getMaxStamina());
            arr.add(h.getStaminaVessels() + " Stamina Vessels, " + h.getHeartContainers() + " Heart Containers");
            arr.add(h.getRecoveryDelay() + " Recovery Delay");
            arr.add("Paragliding: " + h.isParagliding());
            arr.add("Stamina Wheel X: " + PERCENTAGE.format(ModCfg.staminaWheelX()) + ", Stamina Wheel Y: " + PERCENTAGE.format(ModCfg.staminaWheelY()));
            if (!right.isEmpty()) {
                arr.add("");
            }
            right.addAll(0, arr);
        }
    }

    @SubscribeEvent
    public static void beforeCrosshairRender(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay().id().equals((Object)VanillaGuiOverlay.CROSSHAIR.id()) && Minecraft.m_91087_().f_91080_ instanceof StatueBargainScreen) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (Minecraft.m_91087_().f_91080_ == null && ParagliderClientEventHandler.paragliderSettingsKey().m_90859_()) {
            Minecraft.m_91087_().m_91152_((Screen)new ParagliderSettingScreen());
        }
    }

    @SubscribeEvent
    public static void onClickInput(InputEvent.InteractionKeyMappingTriggered event) {
        if (event.isPickBlock()) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        PlayerMovement m = PlayerMovement.of((ICapabilityProvider)player);
        if (m != null && m.isParagliding()) {
            event.setSwingHand(false);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onDrawBlockSelection(RenderHighlightEvent.Block event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        PlayerMovement m = PlayerMovement.of((ICapabilityProvider)player);
        if (m != null && m.isParagliding()) {
            event.setCanceled(true);
        }
    }

    static {
        PERCENTAGE = new DecimalFormat("#.#%");
    }

    @Mod.EventBusSubscriber(modid="paraglider", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    private static class ModEvents {
        private ModEvents() {
        }

        @SubscribeEvent
        public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
            paragliderSettingsKey = new KeyMapping("key.paraglider.paragliderSettings", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.CONTROL, InputConstants.Type.KEYSYM, 80, "key.categories.misc");
            event.register(paragliderSettingsKey);
        }
    }
}

