/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import tictim.paraglider.contents.Contents;
import tictim.paraglider.contents.worldgen.BaseHornedStatuePiece;

public class NetherHornedStatue
extends Structure {
    public static final Codec<NetherHornedStatue> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)NetherHornedStatue.m_226567_((RecordCodecBuilder.Instance)inst), (App)HeightProvider.f_161970_.fieldOf("height").forGetter(s -> s.height)).apply((Applicative)inst, NetherHornedStatue::new));
    private static final ResourceLocation TEMPLATE = new ResourceLocation("paraglider", "nether_horned_statue");
    private static final BlockPos PIVOT = new BlockPos(2, 1, 2);
    public final HeightProvider height;

    public static StructurePieceType.StructureTemplateType pieceType() {
        return BaseHornedStatuePiece.createType(Contents.NETHER_HORNED_STATUE_PIECE, PIVOT);
    }

    public NetherHornedStatue(Structure.StructureSettings structureSettings, HeightProvider height) {
        super(structureSettings);
        this.height = height;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext ctx) {
        WorldgenRandom r = ctx.f_226626_();
        int x = ctx.f_226628_().m_45604_() + r.m_188503_(16);
        int z = ctx.f_226628_().m_45605_() + r.m_188503_(16);
        int seaLevel = ctx.f_226622_().m_6337_();
        int y = this.height.m_213859_((RandomSource)r, new WorldGenerationContext(ctx.f_226622_(), ctx.f_226629_()));
        NoiseColumn col = ctx.f_226622_().m_214184_(x, z, ctx.f_226629_(), ctx.f_226624_());
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos(x, y, z);
        while (y > seaLevel) {
            BlockState state = col.m_183556_(y);
            BlockState bottomState = col.m_183556_(--y);
            if (!state.m_60795_() || !bottomState.m_60713_(Blocks.f_50135_) && !bottomState.m_60783_((BlockGetter)EmptyBlockGetter.INSTANCE, (BlockPos)mpos.m_142448_(y), Direction.UP)) continue;
            break;
        }
        if (y <= seaLevel) {
            return Optional.empty();
        }
        BlockPos pos = new BlockPos(x, y - 1, z);
        return Optional.of(new Structure.GenerationStub(pos, b -> b.m_142679_((StructurePiece)new BaseHornedStatuePiece((StructurePieceType)Contents.NETHER_HORNED_STATUE_PIECE.get(), ctx.f_226625_(), TEMPLATE, pos).rot(PIVOT, Rotation.m_221990_((RandomSource)r), false))));
    }

    public StructureType<?> m_213658_() {
        return (StructureType)Contents.NETHER_HORNED_STATUE.get();
    }

    public GenerationStep.Decoration m_226619_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }
}

