/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import tictim.paraglider.ModCfg;
import tictim.paraglider.contents.Contents;

public class SpiritOrbLoot
extends LootModifier {
    public static final Codec<SpiritOrbLoot> CODEC = RecordCodecBuilder.create(inst -> SpiritOrbLoot.codecStart((RecordCodecBuilder.Instance)inst).and((App)Codec.INT.fieldOf("count").forGetter(m -> m.count)).apply((Applicative)inst, SpiritOrbLoot::new));
    private final int count;

    public SpiritOrbLoot(LootItemCondition[] conditionsIn) {
        this(conditionsIn, 0);
    }

    public SpiritOrbLoot(LootItemCondition[] conditionsIn, int count) {
        super(conditionsIn);
        this.count = count;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (ModCfg.enableSpiritOrbGens()) {
            generatedLoot.add((Object)new ItemStack((ItemLike)Contents.SPIRIT_ORB.get(), this.count));
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

