/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import tictim.paraglider.ModCfg;
import tictim.paraglider.contents.Contents;
import tictim.paraglider.contents.item.ParagliderItem;

public class ParagliderLoot
extends LootModifier {
    public static final Codec<ParagliderLoot> CODEC = RecordCodecBuilder.create(inst -> ParagliderLoot.codecStart((RecordCodecBuilder.Instance)inst).and((App)Codec.BOOL.fieldOf("dekuLeaf").forGetter(m -> m.dekuLeaf)).apply((Applicative)inst, ParagliderLoot::new));
    public final boolean dekuLeaf;

    public ParagliderLoot(LootItemCondition[] conditionsIn) {
        this(conditionsIn, false);
    }

    public ParagliderLoot(LootItemCondition[] conditionsIn, boolean dekuLeaf) {
        super(conditionsIn);
        this.dekuLeaf = dekuLeaf;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ConfigOption configOption = ModCfg.paragliderInTowersOfTheWild();
        if (configOption != ConfigOption.DISABLE) {
            ParagliderItem item = (ParagliderItem)((Object)(configOption == ConfigOption.DEKU_LEAF_ONLY || configOption != ConfigOption.PARAGLIDER_ONLY && this.dekuLeaf ? Contents.DEKU_LEAF : Contents.PARAGLIDER).get());
            ItemStack stack = new ItemStack((ItemLike)item);
            if (context.m_230907_().m_188499_()) {
                stack = DyeableLeatherItem.m_41118_((ItemStack)stack, Arrays.asList(DyeItem.m_41082_((DyeColor)DyeColor.m_41053_((int)context.m_230907_().m_188503_(16))), DyeItem.m_41082_((DyeColor)DyeColor.m_41053_((int)context.m_230907_().m_188503_(16)))));
            }
            generatedLoot.add((Object)stack);
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    public static enum ConfigOption {
        DEFAULT,
        DISABLE,
        PARAGLIDER_ONLY,
        DEKU_LEAF_ONLY;

    }
}

