/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tictim.paraglider.ModCfg;
import tictim.paraglider.capabilities.Paraglider;
import tictim.paraglider.capabilities.PlayerMovement;
import tictim.paraglider.utils.Color;

public abstract class StaminaWheelRenderer {
    private final Map<WheelLevel, Wheel> wheel = new EnumMap<WheelLevel, Wheel>(WheelLevel.class);

    public void renderStamina(PoseStack matrixStack, double x, double y, double z) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        PlayerMovement h = PlayerMovement.of((ICapabilityProvider)player);
        if (h == null) {
            return;
        }
        this.makeWheel(h);
        this.render(matrixStack, x, y, z, ModCfg.debugPlayerMovement() && Paraglider.isParaglider(player.m_21206_()));
    }

    protected abstract void makeWheel(PlayerMovement var1);

    @Nullable
    protected Wheel getWheel(WheelLevel type) {
        return this.wheel.get((Object)type);
    }

    protected void addWheel(WheelLevel wheelLevel, double start, double end, Color color) {
        if ((start = Math.max(0.0, start)) >= (end = Math.min(1.0, end))) {
            return;
        }
        Wheel wheel = this.wheel.get((Object)wheelLevel);
        this.wheel.put(wheelLevel, wheel != null ? wheel.insert(new Wheel(start, end, color)) : new Wheel(start, end, color));
    }

    protected void render(PoseStack stack, double x, double y, double z, boolean debug) {
        RenderSystem.m_69465_();
        if (debug) {
            float linePos = 10.0f;
            Font font = Minecraft.m_91087_().f_91062_;
            for (WheelLevel t : WheelLevel.values()) {
                Wheel wheel = this.getWheel(t);
                if (wheel == null) continue;
                linePos = font.m_92750_(stack, t + ":", 20.0f, linePos, -1);
                linePos = font.m_92750_(stack, wheel.toString(), 30.0f, linePos, -1);
            }
        }
        for (WheelLevel t : WheelLevel.values()) {
            Wheel wheel = this.getWheel(t);
            if (wheel == null) continue;
            RenderSystem.m_157456_((int)0, (ResourceLocation)t.texture);
            wheel.draw(stack, x, y, z, 10.0, debug);
        }
        this.wheel.clear();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static enum WheelLevel {
        FIRST(new ResourceLocation("paraglider", "textures/stamina/first.png")),
        SECOND(new ResourceLocation("paraglider", "textures/stamina/second.png")),
        THIRD(new ResourceLocation("paraglider", "textures/stamina/third.png"));

        public final ResourceLocation texture;

        private WheelLevel(ResourceLocation texture) {
            this.texture = Objects.requireNonNull(texture);
        }

        private int start() {
            return ModCfg.startingStamina() * this.ordinal();
        }

        private int end() {
            return ModCfg.startingStamina() * (1 + this.ordinal());
        }

        public double getProportion(int value) {
            int start = this.start();
            if (start >= value) {
                return 0.0;
            }
            int end = this.end();
            if (end <= value) {
                return 1.0;
            }
            return (double)(value - start) / (double)(end - start);
        }
    }

    public static final class Wheel {
        private double start;
        private double end;
        private final Color color;
        @Nullable
        private Wheel next;
        private static final double[] renderPoints = new double[]{0.0, 0.125, 0.375, 0.625, 0.875, 1.0};

        private Wheel(double start, double end, Color color) {
            this.start = start;
            this.end = end;
            this.color = Objects.requireNonNull(color);
        }

        public Wheel insert(Wheel wheel) {
            return this.insert(wheel, true);
        }

        private Wheel insert(Wheel wheel, boolean overwrite) {
            if (wheel.start <= this.start) {
                if (wheel.end >= this.end) {
                    return this.next != null ? wheel.insert(this.next, false) : wheel;
                }
                this.start = wheel.end;
                wheel.next = this;
                return wheel;
            }
            if (overwrite && wheel.start < this.end) {
                this.end = wheel.start;
            }
            this.next = this.next != null ? this.next.insert(wheel, overwrite) : wheel;
            return this;
        }

        public void draw(PoseStack stack, double x, double y, double z, double radius, boolean debug) {
            ArrayList<Vec2> debugVertices = debug ? new ArrayList<Vec2>() : null;
            this.drawInternal(x, y, z, radius, debugVertices);
            if (debugVertices != null) {
                stack.m_85836_();
                stack.m_85837_(x, y, z);
                Font font = Minecraft.m_91087_().f_91062_;
                for (Vec2 vec : debugVertices) {
                    float f;
                    String s = vec.f_82470_ + " " + vec.f_82471_;
                    float f2 = vec.f_82470_ > 0.0f ? vec.f_82470_ * (float)radius + 2.0f : vec.f_82470_ * (float)radius - 2.0f - (float)font.m_92895_(s);
                    if (vec.f_82471_ > 0.0f) {
                        float f3 = vec.f_82471_ * (float)(-radius) - 2.0f;
                        Objects.requireNonNull(font);
                        f = f3 - 9.0f;
                    } else {
                        f = vec.f_82471_ * (float)(-radius) + 2.0f;
                    }
                    font.m_92750_(stack, s, f2, f, -16711936);
                }
                stack.m_85849_();
            }
        }

        private void drawInternal(double x, double y, double z, double radius, @Nullable List<Vec2> debugVertices) {
            double currentStart;
            RenderSystem.m_157429_((float)this.color.red, (float)this.color.green, (float)this.color.blue, (float)this.color.alpha);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder b = tesselator.m_85915_();
            b.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85817_);
            b.m_5483_(x, y, z).m_7421_(0.5f, 0.5f).m_5752_();
            for (int i = 0; i < renderPoints.length - 1 && !((currentStart = renderPoints[i]) >= this.end); ++i) {
                double currentEnd = renderPoints[i + 1];
                if (currentEnd <= this.start) continue;
                if (currentStart <= this.start) {
                    this.vert(b, x, y, z, this.start, radius, debugVertices);
                }
                if (currentEnd >= this.end) break;
                this.vert(b, x, y, z, currentEnd, radius, debugVertices);
            }
            this.vert(b, x, y, z, this.end, radius, debugVertices);
            tesselator.m_85914_();
            if (this.next != null) {
                this.next.drawInternal(x, y, z, radius, debugVertices);
            }
        }

        private void vert(BufferBuilder b, double x, double y, double z, double point, double radius, @Nullable List<Vec2> debugVertices) {
            double vy;
            double vx;
            if (point == 0.0 || point == 1.0) {
                vx = 0.0;
                vy = 1.0;
            } else if (point == 0.125) {
                vx = -1.0;
                vy = 1.0;
            } else if (point == 0.375) {
                vx = -1.0;
                vy = -1.0;
            } else if (point == 0.625) {
                vx = 1.0;
                vy = -1.0;
            } else if (point == 0.875) {
                vx = 1.0;
                vy = 1.0;
            } else if (point < 0.125 || point > 0.875) {
                vx = -Math.tan(point * (Math.PI * 2));
                vy = 1.0;
            } else if (point < 0.375) {
                vx = -1.0;
                vy = 1.0 / Math.tan(point * (Math.PI * 2));
            } else if (point < 0.625) {
                vx = Math.tan(point * (Math.PI * 2));
                vy = -1.0;
            } else {
                vx = 1.0;
                vy = -1.0 / Math.tan(point * (Math.PI * 2));
            }
            b.m_5483_(x + vx * radius, y + vy * -radius, z).m_7421_((float)(vx / 2.0 + 0.5), (float)(vy / 2.0 + 0.5)).m_5752_();
            if (debugVertices != null) {
                debugVertices.add(new Vec2((float)vx, (float)vy));
            }
        }

        public String toString() {
            return this.next != null ? String.format("[%f ~ %f](#%s) -> \n%s", this.start, this.end, this.color, this.next) : String.format("[%f ~ %f](#%s)", this.start, this.end, this.color);
        }
    }
}

