/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.server.command.impl;

import com.alrex.parcool.api.unstable.Limitation;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.ActionList;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.server.command.args.ActionArgumentType;
import com.alrex.parcool.server.command.args.LimitationIDArgumentType;
import com.alrex.parcool.server.command.args.LimitationItemArgumentType;
import com.alrex.parcool.server.limitation.Limitations;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class ControlLimitationCommand {
    private static final String ARGS_NAME_PLAYERS = "targets";
    private static final String ARGS_NAME_PLAYER = "target";
    private static final String ARGS_NAME_ACTION = "action";
    private static final String ARGS_NAME_STAMINA_CONSUMPTION = "stamina_consumption";
    private static final String ARGS_NAME_POSSIBILITY = "possibility";
    private static final String ARGS_NAME_VALUE = "value";
    private static final String ARGS_NAME_CONFIG_ITEM = "limitation_name";
    private static final String ARGS_NAME_LIMITATION_ID = "limitation_id";

    private static ArgumentBuilder<CommandSourceStack, ?> limitationGetCoreCommands(ArgumentBuilder<CommandSourceStack, ?> builder, boolean hasID, boolean hasPlayer) {
        return builder.then(Commands.m_82127_((String)"boolean").then(Commands.m_82129_((String)ARGS_NAME_CONFIG_ITEM, (ArgumentType)LimitationItemArgumentType.booleans()).executes(context -> ControlLimitationCommand.getBoolLimitation((CommandContext<CommandSourceStack>)context, hasID, hasPlayer)))).then(Commands.m_82127_((String)"integer").then(Commands.m_82129_((String)ARGS_NAME_CONFIG_ITEM, (ArgumentType)LimitationItemArgumentType.integers()).executes(context -> ControlLimitationCommand.getIntLimitation((CommandContext<CommandSourceStack>)context, hasID, hasPlayer)))).then(Commands.m_82127_((String)"reals").then(Commands.m_82129_((String)ARGS_NAME_CONFIG_ITEM, (ArgumentType)LimitationItemArgumentType.doubles()).executes(context -> ControlLimitationCommand.getDoubleLimitation((CommandContext<CommandSourceStack>)context, hasID, hasPlayer)))).then(Commands.m_82127_((String)ARGS_NAME_POSSIBILITY).then(Commands.m_82129_((String)ARGS_NAME_ACTION, (ArgumentType)ActionArgumentType.action()).executes(context -> ControlLimitationCommand.getActionPossibility((CommandContext<CommandSourceStack>)context, hasID, hasPlayer)))).then(Commands.m_82127_((String)"least_stamina_consumption").then(Commands.m_82129_((String)ARGS_NAME_ACTION, (ArgumentType)ActionArgumentType.action()).executes(context -> ControlLimitationCommand.getLeastStaminaConsumption((CommandContext<CommandSourceStack>)context, hasID, hasPlayer))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> limitationSetCoreCommands(ArgumentBuilder<CommandSourceStack, ?> builder, boolean hasID, boolean hasPlayer) {
        return builder.then(Commands.m_82127_((String)"to_default").executes(context -> ControlLimitationCommand.setLimitationDefault((CommandContext<CommandSourceStack>)context, hasID, hasPlayer))).then(Commands.m_82127_((String)"boolean").then(Commands.m_82129_((String)ARGS_NAME_CONFIG_ITEM, (ArgumentType)LimitationItemArgumentType.booleans()).then(Commands.m_82129_((String)ARGS_NAME_VALUE, (ArgumentType)BoolArgumentType.bool()).executes(context -> ControlLimitationCommand.setBoolLimitation((CommandContext<CommandSourceStack>)context, hasID, hasPlayer))))).then(Commands.m_82127_((String)"integer").then(Commands.m_82129_((String)ARGS_NAME_CONFIG_ITEM, (ArgumentType)LimitationItemArgumentType.integers()).then(Commands.m_82129_((String)ARGS_NAME_VALUE, (ArgumentType)IntegerArgumentType.integer()).executes(context -> ControlLimitationCommand.setIntLimitation((CommandContext<CommandSourceStack>)context, hasID, hasPlayer))))).then(Commands.m_82127_((String)"reals").then(Commands.m_82129_((String)ARGS_NAME_CONFIG_ITEM, (ArgumentType)LimitationItemArgumentType.doubles()).then(Commands.m_82129_((String)ARGS_NAME_VALUE, (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> ControlLimitationCommand.setDoubleLimitation((CommandContext<CommandSourceStack>)context, hasID, hasPlayer))))).then(Commands.m_82127_((String)ARGS_NAME_POSSIBILITY).then(Commands.m_82129_((String)ARGS_NAME_ACTION, (ArgumentType)ActionArgumentType.action()).then(Commands.m_82129_((String)ARGS_NAME_POSSIBILITY, (ArgumentType)BoolArgumentType.bool()).executes(context -> ControlLimitationCommand.changePossibilityOfAction((CommandContext<CommandSourceStack>)context, hasID, hasPlayer))))).then(Commands.m_82127_((String)"least_stamina_consumption").then(Commands.m_82129_((String)ARGS_NAME_ACTION, (ArgumentType)ActionArgumentType.action()).then(Commands.m_82129_((String)ARGS_NAME_STAMINA_CONSUMPTION, (ArgumentType)IntegerArgumentType.integer((int)0, (int)Integer.MAX_VALUE)).executes(context -> ControlLimitationCommand.changeStaminaConsumption((CommandContext<CommandSourceStack>)context, hasID, hasPlayer)))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> getLimitationByNameCommands(boolean multiPlayer, Function<RequiredArgumentBuilder<CommandSourceStack, ?>, ArgumentBuilder<CommandSourceStack, ?>> afterCommand) {
        if (multiPlayer) {
            return Commands.m_82129_((String)ARGS_NAME_LIMITATION_ID, (ArgumentType)LimitationIDArgumentType.limitation()).then(Commands.m_82127_((String)"of").then(afterCommand.apply(Commands.m_82129_((String)ARGS_NAME_PLAYERS, (ArgumentType)EntityArgument.m_91470_()))));
        }
        return Commands.m_82129_((String)ARGS_NAME_LIMITATION_ID, (ArgumentType)LimitationIDArgumentType.limitation()).then(Commands.m_82127_((String)"of").then(afterCommand.apply(Commands.m_82129_((String)ARGS_NAME_PLAYER, (ArgumentType)EntityArgument.m_91466_()))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> getIndividualLimitationCommands(boolean multiPlayer, Function<RequiredArgumentBuilder<CommandSourceStack, ?>, ArgumentBuilder<CommandSourceStack, ?>> afterCommand) {
        if (multiPlayer) {
            return Commands.m_82127_((String)"individual").then(Commands.m_82127_((String)"of").then(afterCommand.apply(Commands.m_82129_((String)ARGS_NAME_PLAYERS, (ArgumentType)EntityArgument.m_91470_()))));
        }
        return Commands.m_82127_((String)"individual").then(Commands.m_82127_((String)"of").then(afterCommand.apply(Commands.m_82129_((String)ARGS_NAME_PLAYER, (ArgumentType)EntityArgument.m_91466_()))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> getGlobalLimitationCommands(Function<LiteralArgumentBuilder<CommandSourceStack>, ArgumentBuilder<CommandSourceStack, ?>> afterCommand) {
        return afterCommand.apply((LiteralArgumentBuilder<CommandSourceStack>)Commands.m_82127_((String)"global"));
    }

    public static ArgumentBuilder<CommandSourceStack, ?> getBuilder() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"limitation").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"get").then(ControlLimitationCommand.getLimitationByNameCommands(false, it -> {
            it.executes(context -> ControlLimitationCommand.getLimitationInfo((CommandContext<CommandSourceStack>)context, true, true));
            ControlLimitationCommand.limitationGetCoreCommands(it, true, true);
            return it;
        }))).then(ControlLimitationCommand.getIndividualLimitationCommands(false, it -> {
            it.executes(context -> ControlLimitationCommand.getLimitationInfo((CommandContext<CommandSourceStack>)context, false, true));
            ControlLimitationCommand.limitationGetCoreCommands(it, false, true);
            return it;
        }))).then(ControlLimitationCommand.getGlobalLimitationCommands(it -> {
            it.executes(context -> ControlLimitationCommand.getLimitationInfo((CommandContext<CommandSourceStack>)context, false, false));
            ControlLimitationCommand.limitationGetCoreCommands(it, false, false);
            return it;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"set").requires(commandSource -> commandSource.m_6761_(2))).then(ControlLimitationCommand.getLimitationByNameCommands(true, it -> {
            ControlLimitationCommand.limitationSetCoreCommands(it, true, true);
            return it;
        }))).then(ControlLimitationCommand.getIndividualLimitationCommands(true, it -> {
            ControlLimitationCommand.limitationSetCoreCommands(it, false, true);
            return it;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"enable").requires(commandSource -> commandSource.m_6761_(2))).then(ControlLimitationCommand.getLimitationByNameCommands(true, it -> {
            it.executes(context -> ControlLimitationCommand.enableLimitation((CommandContext<CommandSourceStack>)context, true, true));
            return it;
        }))).then(ControlLimitationCommand.getIndividualLimitationCommands(true, it -> {
            it.executes(context -> ControlLimitationCommand.enableLimitation((CommandContext<CommandSourceStack>)context, false, true));
            return it;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"disable").requires(commandSource -> commandSource.m_6761_(2))).then(ControlLimitationCommand.getLimitationByNameCommands(true, it -> {
            it.executes(context -> ControlLimitationCommand.disableLimitation((CommandContext<CommandSourceStack>)context, true, true));
            return it;
        }))).then(ControlLimitationCommand.getIndividualLimitationCommands(true, it -> {
            it.executes(context -> ControlLimitationCommand.disableLimitation((CommandContext<CommandSourceStack>)context, false, true));
            return it;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"delete").requires(commandSource -> commandSource.m_6761_(2))).then(Commands.m_82129_((String)ARGS_NAME_LIMITATION_ID, (ArgumentType)LimitationIDArgumentType.limitation()).executes(ControlLimitationCommand::deleteLimitation)));
    }

    private static List<Limitation> getLimitationInstance(Collection<ServerPlayer> players, @Nullable Limitation.ID id, @Nullable MinecraftServer server) {
        if (players.isEmpty()) {
            if (server != null) {
                return Collections.singletonList(Limitation.getGlobal(server));
            }
            if (id == null) {
                // empty if block
            }
        } else {
            if (id != null) {
                LinkedList<Limitation> list = new LinkedList<Limitation>();
                for (ServerPlayer player : players) {
                    list.add(Limitation.get(player, id));
                }
                return list;
            }
            LinkedList<Limitation> list = new LinkedList<Limitation>();
            for (ServerPlayer player : players) {
                list.add(Limitation.getIndividual(player));
            }
            return list;
        }
        return Collections.emptyList();
    }

    private static int getBoolLimitation(CommandContext<CommandSourceStack> context, boolean hasID, boolean hasPlayer) throws CommandSyntaxException {
        List<Limitation> limitations = ControlLimitationCommand.getLimitationInstance(hasPlayer ? Collections.singletonList(EntityArgument.m_91474_(context, (String)ARGS_NAME_PLAYER)) : Collections.emptyList(), hasID ? LimitationIDArgumentType.getLimitationID(context, ARGS_NAME_LIMITATION_ID) : null, ((CommandSourceStack)context.getSource()).m_81377_());
        ParCoolConfig.Server.Booleans item = LimitationItemArgumentType.getBool(context, ARGS_NAME_CONFIG_ITEM);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)Boolean.toString(limitations.get(0).get(item))), false);
        return 0;
    }

    private static int getIntLimitation(CommandContext<CommandSourceStack> context, boolean hasID, boolean hasPlayer) throws CommandSyntaxException {
        List<Limitation> limitations = ControlLimitationCommand.getLimitationInstance(hasPlayer ? Collections.singletonList(EntityArgument.m_91474_(context, (String)ARGS_NAME_PLAYER)) : Collections.emptyList(), hasID ? LimitationIDArgumentType.getLimitationID(context, ARGS_NAME_LIMITATION_ID) : null, ((CommandSourceStack)context.getSource()).m_81377_());
        ParCoolConfig.Server.Integers item = LimitationItemArgumentType.getInt(context, ARGS_NAME_CONFIG_ITEM);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)Integer.toString(limitations.get(0).get(item))), false);
        return 0;
    }

    private static int getDoubleLimitation(CommandContext<CommandSourceStack> context, boolean hasID, boolean hasPlayer) throws CommandSyntaxException {
        List<Limitation> limitations = ControlLimitationCommand.getLimitationInstance(hasPlayer ? Collections.singletonList(EntityArgument.m_91474_(context, (String)ARGS_NAME_PLAYER)) : Collections.emptyList(), hasID ? LimitationIDArgumentType.getLimitationID(context, ARGS_NAME_LIMITATION_ID) : null, ((CommandSourceStack)context.getSource()).m_81377_());
        ParCoolConfig.Server.Doubles item = LimitationItemArgumentType.getDouble(context, ARGS_NAME_CONFIG_ITEM);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)Double.toString(limitations.get(0).get(item))), false);
        return 0;
    }

    private static int getActionPossibility(CommandContext<CommandSourceStack> context, boolean hasID, boolean hasPlayer) throws CommandSyntaxException {
        List<Limitation> limitations = ControlLimitationCommand.getLimitationInstance(hasPlayer ? Collections.singletonList(EntityArgument.m_91474_(context, (String)ARGS_NAME_PLAYER)) : Collections.emptyList(), hasID ? LimitationIDArgumentType.getLimitationID(context, ARGS_NAME_LIMITATION_ID) : null, ((CommandSourceStack)context.getSource()).m_81377_());
        Class<? extends Action> action = ActionArgumentType.getAction(context, ARGS_NAME_ACTION);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)Boolean.toString(limitations.get(0).isPermitted(action))), false);
        return 0;
    }

    private static int getLimitationInfo(CommandContext<CommandSourceStack> context, boolean hasID, boolean hasPlayer) throws CommandSyntaxException {
        List<Limitation> limitations = ControlLimitationCommand.getLimitationInstance(hasPlayer ? Collections.singletonList(EntityArgument.m_91474_(context, (String)ARGS_NAME_PLAYER)) : Collections.emptyList(), hasID ? LimitationIDArgumentType.getLimitationID(context, ARGS_NAME_LIMITATION_ID) : null, ((CommandSourceStack)context.getSource()).m_81377_());
        Limitation limitation = limitations.get(0);
        StringBuilder builder = new StringBuilder();
        builder.append("- Limitation Info -\n");
        builder.append("Enabled : ").append(limitation.isEnabled()).append('\n');
        for (Class<? extends Action> action : ActionList.ACTIONS) {
            builder.append("  ").append(action.getSimpleName()).append(" : ").append('\n').append("    ").append("permitted : ").append(limitation.isPermitted(action)).append('\n').append("    ").append("stamina consumption : ").append(limitation.getLeastStaminaConsumption(action)).append('\n');
        }
        for (ParCoolConfig.Server.Booleans booleans : ParCoolConfig.Server.Booleans.values()) {
            builder.append("  ").append(booleans.getPath()).append(" : ").append(limitation.get(booleans)).append('\n');
        }
        for (Enum enum_ : ParCoolConfig.Server.Integers.values()) {
            builder.append("  ").append(((ParCoolConfig.Server.Integers)enum_).getPath()).append(" : ").append(limitation.get((ParCoolConfig.Server.Integers)enum_)).append('\n');
        }
        for (Enum enum_ : ParCoolConfig.Server.Doubles.values()) {
            builder.append("  ").append(((ParCoolConfig.Server.Doubles)enum_).getPath()).append(" : ").append(limitation.get((ParCoolConfig.Server.Doubles)enum_)).append('\n');
        }
        builder.append("----------");
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)builder.toString()), false);
        return 0;
    }

    private static int getLeastStaminaConsumption(CommandContext<CommandSourceStack> context, boolean hasID, boolean hasPlayer) throws CommandSyntaxException {
        List<Limitation> limitations = ControlLimitationCommand.getLimitationInstance(hasPlayer ? Collections.singletonList(EntityArgument.m_91474_(context, (String)ARGS_NAME_PLAYER)) : Collections.emptyList(), hasID ? LimitationIDArgumentType.getLimitationID(context, ARGS_NAME_LIMITATION_ID) : null, ((CommandSourceStack)context.getSource()).m_81377_());
        Class<? extends Action> action = ActionArgumentType.getAction(context, ARGS_NAME_ACTION);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)Integer.toString(limitations.get(0).getLeastStaminaConsumption(action))), false);
        return 0;
    }

    private static int setLimitationDefault(CommandContext<CommandSourceStack> context, boolean hasID, boolean hasPlayer) throws CommandSyntaxException {
        List<Limitation> limitations = ControlLimitationCommand.getLimitationInstance(hasPlayer ? EntityArgument.m_91477_(context, (String)ARGS_NAME_PLAYERS) : Collections.emptyList(), hasID ? LimitationIDArgumentType.getLimitationID(context, ARGS_NAME_LIMITATION_ID) : null, ((CommandSourceStack)context.getSource()).m_81377_());
        int num = 0;
        for (Limitation limitation : limitations) {
            limitation.setDefault().apply();
            limitation.save();
            ++num;
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"parcool.command.message.success.setLimitationToDefault", (Object[])new Object[]{num}), true);
        return 0;
    }

    private static int setBoolLimitation(CommandContext<CommandSourceStack> context, boolean hasID, boolean hasPlayer) throws CommandSyntaxException {
        List<Limitation> limitations = ControlLimitationCommand.getLimitationInstance(hasPlayer ? EntityArgument.m_91477_(context, (String)ARGS_NAME_PLAYERS) : Collections.emptyList(), hasID ? LimitationIDArgumentType.getLimitationID(context, ARGS_NAME_LIMITATION_ID) : null, ((CommandSourceStack)context.getSource()).m_81377_());
        ParCoolConfig.Server.Booleans item = LimitationItemArgumentType.getBool(context, ARGS_NAME_CONFIG_ITEM);
        boolean value = BoolArgumentType.getBool(context, (String)ARGS_NAME_VALUE);
        int num = 0;
        for (Limitation limitation : limitations) {
            limitation.set(item, value).apply();
            limitation.save();
            ++num;
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"parcool.command.message.success.set", (Object[])new Object[]{num, item.getPath(), Boolean.toString(value)}), true);
        return 0;
    }

    private static int setIntLimitation(CommandContext<CommandSourceStack> context, boolean hasID, boolean hasPlayer) throws CommandSyntaxException {
        List<Limitation> limitations = ControlLimitationCommand.getLimitationInstance(hasPlayer ? EntityArgument.m_91477_(context, (String)ARGS_NAME_PLAYERS) : Collections.emptyList(), hasID ? LimitationIDArgumentType.getLimitationID(context, ARGS_NAME_LIMITATION_ID) : null, ((CommandSourceStack)context.getSource()).m_81377_());
        ParCoolConfig.Server.Integers item = LimitationItemArgumentType.getInt(context, ARGS_NAME_CONFIG_ITEM);
        int value = IntegerArgumentType.getInteger(context, (String)ARGS_NAME_VALUE);
        if (value < item.Min) {
            value = item.Min;
        }
        if (value > item.Max) {
            value = item.Max;
        }
        int num = 0;
        for (Limitation limitation : limitations) {
            limitation.set(item, value).apply();
            limitation.save();
            ++num;
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"parcool.command.message.success.set", (Object[])new Object[]{num, item.getPath(), Integer.toString(value)}), true);
        return 0;
    }

    private static int setDoubleLimitation(CommandContext<CommandSourceStack> context, boolean hasID, boolean hasPlayer) throws CommandSyntaxException {
        List<Limitation> limitations = ControlLimitationCommand.getLimitationInstance(hasPlayer ? EntityArgument.m_91477_(context, (String)ARGS_NAME_PLAYERS) : Collections.emptyList(), hasID ? LimitationIDArgumentType.getLimitationID(context, ARGS_NAME_LIMITATION_ID) : null, ((CommandSourceStack)context.getSource()).m_81377_());
        ParCoolConfig.Server.Doubles item = LimitationItemArgumentType.getDouble(context, ARGS_NAME_CONFIG_ITEM);
        double value = DoubleArgumentType.getDouble(context, (String)ARGS_NAME_VALUE);
        if (value < item.Min) {
            value = item.Min;
        }
        if (value > item.Max) {
            value = item.Max;
        }
        int num = 0;
        for (Limitation limitation : limitations) {
            limitation.set(item, value).apply();
            limitation.save();
            ++num;
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"parcool.command.message.success.set", (Object[])new Object[]{num, item.getPath(), Double.toString(value)}), true);
        return 0;
    }

    private static int enableLimitation(CommandContext<CommandSourceStack> context, boolean hasID, boolean hasPlayer) throws CommandSyntaxException {
        List<Limitation> limitations = ControlLimitationCommand.getLimitationInstance(hasPlayer ? EntityArgument.m_91477_(context, (String)ARGS_NAME_PLAYERS) : Collections.emptyList(), hasID ? LimitationIDArgumentType.getLimitationID(context, ARGS_NAME_LIMITATION_ID) : null, ((CommandSourceStack)context.getSource()).m_81377_());
        int num = 0;
        for (Limitation limitation : limitations) {
            limitation.enable().apply();
            limitation.save();
            ++num;
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"parcool.command.message.success.enableLimitation", (Object[])new Object[]{num}), true);
        return 0;
    }

    private static int disableLimitation(CommandContext<CommandSourceStack> context, boolean hasID, boolean hasPlayer) throws CommandSyntaxException {
        List<Limitation> limitations = ControlLimitationCommand.getLimitationInstance(hasPlayer ? EntityArgument.m_91477_(context, (String)ARGS_NAME_PLAYERS) : Collections.emptyList(), hasID ? LimitationIDArgumentType.getLimitationID(context, ARGS_NAME_LIMITATION_ID) : null, ((CommandSourceStack)context.getSource()).m_81377_());
        int num = 0;
        for (Limitation limitation : limitations) {
            limitation.disable().apply();
            limitation.save();
            ++num;
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"parcool.command.message.success.disableLimitation", (Object[])new Object[]{num}), true);
        return 0;
    }

    private static int deleteLimitation(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Limitation.ID limitation = LimitationIDArgumentType.getLimitationID(context, ARGS_NAME_LIMITATION_ID);
        if (Limitation.delete(limitation)) {
            for (ServerPlayer player : ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11314_()) {
                Limitations.update(player);
            }
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"parcool.command.message.success.deleteLimitation", (Object[])new Object[]{limitation.toString()}), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Error:deleting folder failed"));
        }
        return 0;
    }

    private static int changeStaminaConsumption(CommandContext<CommandSourceStack> context, boolean hasID, boolean hasPlayer) throws CommandSyntaxException {
        List<Limitation> limitations = ControlLimitationCommand.getLimitationInstance(hasPlayer ? EntityArgument.m_91477_(context, (String)ARGS_NAME_PLAYERS) : Collections.emptyList(), hasID ? LimitationIDArgumentType.getLimitationID(context, ARGS_NAME_LIMITATION_ID) : null, ((CommandSourceStack)context.getSource()).m_81377_());
        Class<? extends Action> action = ActionArgumentType.getAction(context, ARGS_NAME_ACTION);
        int newValue = IntegerArgumentType.getInteger(context, (String)ARGS_NAME_STAMINA_CONSUMPTION);
        int num = 0;
        for (Limitation limitation : limitations) {
            limitation.setLeastStaminaConsumption(action, newValue).apply();
            limitation.save();
            ++num;
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"parcool.command.message.success.setStaminaConsumption", (Object[])new Object[]{num, action.getSimpleName(), newValue}), true);
        return 0;
    }

    private static int changePossibilityOfAction(CommandContext<CommandSourceStack> context, boolean hasID, boolean hasPlayer) throws CommandSyntaxException {
        List<Limitation> limitations = ControlLimitationCommand.getLimitationInstance(hasPlayer ? EntityArgument.m_91477_(context, (String)ARGS_NAME_PLAYERS) : Collections.emptyList(), hasID ? LimitationIDArgumentType.getLimitationID(context, ARGS_NAME_LIMITATION_ID) : null, ((CommandSourceStack)context.getSource()).m_81377_());
        Class<? extends Action> action = ActionArgumentType.getAction(context, ARGS_NAME_ACTION);
        boolean newValue = BoolArgumentType.getBool(context, (String)ARGS_NAME_POSSIBILITY);
        int num = 0;
        for (Limitation limitation : limitations) {
            limitation.permit(action, newValue).apply();
            limitation.save();
            ++num;
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"parcool.command.message.success.setPermissionOfAction", (Object[])new Object[]{num, action.getSimpleName(), newValue}), true);
        return 0;
    }
}

