/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.extern.epicfight;

import com.alrex.parcool.api.Effects;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.common.capability.stamina.Stamina;
import com.alrex.parcool.extern.epicfight.EpicFightManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class EpicFightStamina
implements IStamina {
    private final Player player;
    private float consumeBuffer = 0.0f;
    private final Stamina parcoolStamina;

    public EpicFightStamina(Player player) {
        this.player = player;
        this.parcoolStamina = new Stamina(player);
    }

    @Override
    public int getActualMaxStamina() {
        if (EpicFightManager.isBattleMode(this.player)) {
            PlayerPatch<?> patch = EpicFightManager.getPlayerPatch(this.player);
            if (patch == null) {
                return 0;
            }
            return (int)patch.getMaxStamina();
        }
        return this.parcoolStamina.getActualMaxStamina();
    }

    @Override
    public int get() {
        if (EpicFightManager.isBattleMode(this.player)) {
            PlayerPatch<?> patch = EpicFightManager.getPlayerPatch(this.player);
            if (patch == null) {
                return 0;
            }
            return (int)patch.getStamina();
        }
        return this.parcoolStamina.get();
    }

    @Override
    public int getOldValue() {
        if (EpicFightManager.isBattleMode(this.player)) {
            return this.get();
        }
        return this.parcoolStamina.getOldValue();
    }

    @Override
    public void consume(int value) {
        Parkourability parkourability = Parkourability.get(this.player);
        if (parkourability == null) {
            return;
        }
        if (this.isExhausted() || parkourability.getActionInfo().isStaminaInfinite(this.player.m_5833_() || this.player.m_7500_()) || this.player.m_21023_((MobEffect)Effects.INEXHAUSTIBLE.get())) {
            return;
        }
        if (EpicFightManager.isBattleMode(this.player)) {
            this.consumeBuffer += (float)value / 15.0f;
        } else {
            this.parcoolStamina.consume(value);
        }
    }

    @Override
    public void recover(int value) {
        if (!EpicFightManager.isBattleMode(this.player)) {
            this.parcoolStamina.recover(value);
        }
    }

    @Override
    public boolean isExhausted() {
        Parkourability parkourability = Parkourability.get(this.player);
        if (parkourability == null) {
            return false;
        }
        if (parkourability.getActionInfo().isStaminaInfinite(this.player.m_5833_() || this.player.m_7500_()) || this.player.m_21023_((MobEffect)Effects.INEXHAUSTIBLE.get())) {
            return false;
        }
        if (!EpicFightManager.isBattleMode(this.player)) {
            return this.parcoolStamina.isExhausted();
        }
        return false;
    }

    @Override
    public void setExhaustion(boolean value) {
        if (!EpicFightManager.isBattleMode(this.player)) {
            this.parcoolStamina.setExhaustion(value);
        }
    }

    @Override
    public void tick() {
        if (!EpicFightManager.isBattleMode(this.player)) {
            this.parcoolStamina.tick();
        }
    }

    @Override
    public void set(int value) {
        if (!EpicFightManager.isBattleMode(this.player)) {
            this.parcoolStamina.set(value);
        }
    }

    @Override
    public boolean wantToConsumeOnServer() {
        return EpicFightManager.isBattleMode(this.player) && this.consumeBuffer != 0.0f;
    }

    @Override
    public int getRequestedValueConsumedOnServer() {
        int neededValue = (int)(this.consumeBuffer * 10000.0f);
        this.consumeBuffer = 0.0f;
        return neededValue;
    }

    public static void consumeOnServer(ServerPlayer player, int value) {
        PlayerPatch<?> patch = EpicFightManager.getPlayerPatch((Player)player);
        if (patch == null) {
            return;
        }
        patch.setStamina(patch.getStamina() - (float)value / 10000.0f);
    }
}

