/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.network;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.common.info.ServerLimitation;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class SyncLimitationMessage {
    private final ByteBuffer data = ByteBuffer.allocate(512);

    public void encode(FriendlyByteBuf packet) {
        packet.writeBytes(this.data);
        this.data.rewind();
    }

    public static SyncLimitationMessage decode(FriendlyByteBuf packet) {
        SyncLimitationMessage message = new SyncLimitationMessage();
        while (packet.isReadable()) {
            message.data.put(packet.readByte());
        }
        message.data.flip();
        return message;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            Parkourability parkourability = Parkourability.get((Player)player);
            if (parkourability == null) {
                return;
            }
            parkourability.getActionInfo().setServerLimitation(ServerLimitation.readFrom(this.data));
        });
        contextSupplier.get().setPacketHandled(true);
    }

    public static void sync(ServerPlayer player) {
        Parkourability parkourability = Parkourability.get((Player)player);
        if (parkourability == null) {
            return;
        }
        SyncLimitationMessage msg = new SyncLimitationMessage();
        parkourability.getActionInfo().getServerLimitation().writeTo(msg.data);
        msg.data.flip();
        ParCool.CHANNEL_INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)msg);
    }
}

