/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.api.SoundEvents;
import com.alrex.parcool.client.animation.impl.VerticalWallRunAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.CatLeap;
import com.alrex.parcool.common.action.impl.ClingToCliff;
import com.alrex.parcool.common.action.impl.Crawl;
import com.alrex.parcool.common.action.impl.FastRun;
import com.alrex.parcool.common.action.impl.Flipping;
import com.alrex.parcool.common.action.impl.HorizontalWallRun;
import com.alrex.parcool.common.action.impl.Vault;
import com.alrex.parcool.common.action.impl.WallSlide;
import com.alrex.parcool.common.capability.Animation;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.utilities.VectorUtil;
import com.alrex.parcool.utilities.WorldUtil;
import java.nio.ByteBuffer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;

public class VerticalWallRun
extends Action {
    private double playerYSpeed = 0.0;
    private Vec3 wallDirection = null;

    @Override
    public void onTick(Player player, Parkourability parkourability, IStamina stamina) {
        this.playerYSpeed = player.m_20184_().m_7098_();
    }

    @Override
    public boolean canStart(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        boolean able;
        int tickAfterJump = parkourability.getAdditionalProperties().getTickAfterLastJump();
        Vec3 lookVec = player.m_20154_();
        boolean bl = able = !stamina.isExhausted() && Math.abs(player.m_20184_().m_7098_()) <= (double)(player.m_20206_() / 5.0f) && 4 < tickAfterJump && tickAfterJump < 13 && this.getNotDoingTick() > 15 && !player.m_21255_() && KeyBindings.getKeyJump().m_90857_() && !parkourability.get(ClingToCliff.class).isDoing() && !parkourability.get(Crawl.class).isDoing() && !parkourability.get(CatLeap.class).isDoing() && !parkourability.get(WallSlide.class).isDoing() && !parkourability.get(HorizontalWallRun.class).isDoing() && !parkourability.get(Vault.class).isDoing() && !parkourability.get(Flipping.class).isDoing() && parkourability.get(FastRun.class).getNotDashTick(parkourability.getAdditionalProperties()) < 8 && parkourability.getAdditionalProperties().getLastSprintingTick() > 12 && lookVec.m_7098_() > 0.0;
        if (able) {
            double height;
            Vec3 wall = WorldUtil.getWall((LivingEntity)player);
            if (wall == null) {
                return false;
            }
            if ((wall = wall.m_82541_()).m_82526_(VectorUtil.fromYawDegree(player.m_6080_())) > 0.93 && (height = WorldUtil.getWallHeight((LivingEntity)player, wall, (double)player.m_20206_() * 2.2, 0.2)) > 2.3) {
                BlockPos targetBlock = new BlockPos(player.m_20185_() + wall.m_7096_(), player.m_20191_().f_82289_ + (double)player.m_20206_() * 0.5, player.m_20189_() + wall.m_7094_());
                if (!player.f_19853_.m_46749_(targetBlock)) {
                    return false;
                }
                float slipperiness = player.f_19853_.m_8055_(targetBlock).getFriction((LevelReader)player.f_19853_, targetBlock, (Entity)player);
                startInfo.putDouble(height);
                startInfo.putFloat(slipperiness);
                startInfo.putDouble(wall.m_7096_());
                startInfo.putDouble(wall.m_7098_());
                startInfo.putDouble(wall.m_7094_());
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canContinue(Player player, Parkourability parkourability, IStamina stamina) {
        Vec3 wall = WorldUtil.getWall((LivingEntity)player);
        if (wall == null) {
            return false;
        }
        return (wall = wall.m_82541_()).m_82526_(VectorUtil.fromYawDegree(player.m_6080_())) > 0.93 && this.playerYSpeed > 0.0 || this.getDoingTick() > 30;
    }

    @Override
    public void onStartInLocalClient(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        double height = startData.getDouble();
        float slipperiness = startData.getFloat();
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.m_5496_((SoundEvent)SoundEvents.VERTICAL_WALL_RUN.get(), 1.0f, 1.0f);
        }
        player.m_20256_(player.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82520_(0.0, (slipperiness <= 0.8f ? 0.32 : 0.16) * Math.sqrt(height), 0.0));
        this.onStartInOtherClient(player, parkourability, startData);
    }

    @Override
    public void onStartInOtherClient(Player player, Parkourability parkourability, ByteBuffer startData) {
        Animation animation;
        startData.position(12);
        this.wallDirection = new Vec3(startData.getDouble(), startData.getDouble(), startData.getDouble());
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.m_5496_((SoundEvent)SoundEvents.VERTICAL_WALL_RUN.get(), 1.0f, 1.0f);
        }
        if ((animation = Animation.get(player)) != null) {
            animation.setAnimator(new VerticalWallRunAnimator());
        }
    }

    @Override
    public void onRenderTick(TickEvent.RenderTickEvent event, Player player, Parkourability parkourability) {
        if (this.wallDirection != null && this.isDoing()) {
            player.m_5616_((float)VectorUtil.toYawDegree(this.wallDirection));
            player.f_20884_ = player.f_20883_ = player.m_6080_();
        }
    }

    @Override
    public void onWorkingTickInClient(Player player, Parkourability parkourability, IStamina stamina) {
        this.spawnRunningParticle(player);
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnStart;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnRunningParticle(Player player) {
        if (!ParCoolConfig.Client.Booleans.EnableActionParticles.get().booleanValue()) {
            return;
        }
        if (this.wallDirection == null) {
            return;
        }
        Level level = player.f_19853_;
        Vec3 pos = player.m_20182_();
        BlockPos leanedBlock = new BlockPos(pos.m_82520_(this.wallDirection.m_7096_(), (double)player.m_20206_() * 0.25, this.wallDirection.m_7094_()));
        if (!level.m_46749_(leanedBlock)) {
            return;
        }
        float width = player.m_20205_();
        BlockState blockstate = level.m_8055_(leanedBlock);
        Vec3 normalizedWallVec = this.wallDirection.m_82541_();
        Vec3 orthogonalToWallVec = normalizedWallVec.m_82524_(1.5707964f);
        if (blockstate.m_60799_() != RenderShape.INVISIBLE) {
            Vec3 particlePos = new Vec3(pos.m_7096_() + (normalizedWallVec.m_7096_() * 0.4 + orthogonalToWallVec.m_7096_() * (player.m_217043_().m_188500_() - 0.5)) * (double)width, pos.m_7098_() + 0.1 + 0.3 * player.m_217043_().m_188500_(), pos.m_7094_() + (normalizedWallVec.m_7094_() * 0.4 + orthogonalToWallVec.m_7094_() * (player.m_217043_().m_188500_() - 0.5)) * (double)width);
            Vec3 particleSpeed = normalizedWallVec.m_82548_().m_82524_((float)(0.6283185307179586 * (player.m_217043_().m_188500_() - 0.5))).m_82490_(2.0 + 4.0 * player.m_217043_().m_188500_()).m_82520_(0.0, 0.5, 0.0);
            level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(leanedBlock), particlePos.m_7096_(), particlePos.m_7098_(), particlePos.m_7094_(), particleSpeed.m_7096_(), particleSpeed.m_7098_(), particleSpeed.m_7094_());
        }
    }
}

