/*
 * Decompiled with CFR 0.152.
 */
package org.thinkingstudio.obsidianui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.thinkingstudio.obsidianui.Position;
import org.thinkingstudio.obsidianui.Tooltipable;
import org.thinkingstudio.obsidianui.navigation.NavigationDirection;
import org.thinkingstudio.obsidianui.widget.AbstractSpruceButtonWidget;

public class SpruceSliderWidget
extends AbstractSpruceButtonWidget
implements Tooltipable {
    private Component baseMessage;
    protected double value;
    private final Consumer<SpruceSliderWidget> applyConsumer;
    private double multiplier;
    private String sign;
    private boolean inUse = false;
    private static final ResourceLocation SLIDER = new ResourceLocation("widget/slider");
    private static final ResourceLocation SLIDER_HANDLE = new ResourceLocation("widget/slider_handle");
    private static final ResourceLocation SLIDER_HANDLE_HIGHLIGHTED = new ResourceLocation("widget/slider_handle_highlighted");

    public SpruceSliderWidget(Position position, int width, int height, Component message, double value, Consumer<SpruceSliderWidget> applyConsumer, double multiplier, String sign) {
        super(position, width, height, message);
        this.value = value;
        this.baseMessage = message;
        this.applyConsumer = applyConsumer;
        this.multiplier = multiplier;
        this.sign = sign;
        this.updateMessage();
    }

    public SpruceSliderWidget(Position position, int width, int height, Component message, double progress, Consumer<SpruceSliderWidget> applyConsumer) {
        this(position, width, height, message, progress, applyConsumer, 100.0, "%");
    }

    public double getValue() {
        return this.value;
    }

    private void setValue(double value) {
        double oldValue = this.value;
        this.value = Mth.m_14008_((double)value, (double)0.0, (double)1.0);
        if (oldValue != this.value) {
            this.applyValue();
        }
        this.updateMessage();
    }

    public int getIntValue() {
        return (int)(this.value * this.multiplier);
    }

    public void setIntValue(int value) {
        this.setValue((double)value / this.multiplier);
    }

    public Component getBaseMessage() {
        return this.baseMessage;
    }

    public void setBaseMessage(Component baseMessage) {
        this.baseMessage = baseMessage;
    }

    protected void updateMessage() {
        this.setMessage((Component)this.baseMessage.m_6881_().m_130946_(": " + this.getIntValue() + this.sign));
    }

    protected void applyValue() {
        this.applyConsumer.accept(this);
    }

    @Override
    public boolean onNavigation(NavigationDirection direction, boolean tab) {
        if (direction.isHorizontal() && !tab && (direction.isLookingForward() && this.value < 1.0 || this.value > 0.0)) {
            this.setValue(this.getValue() + (direction.isLookingForward() ? 1.0 / this.multiplier : -(1.0 / this.multiplier)));
            return true;
        }
        return super.onNavigation(direction, tab);
    }

    @Override
    protected void onClick(double mouseX, double mouseY) {
        this.setValueFromMouse(mouseX);
        this.inUse = true;
    }

    @Override
    protected void onRelease(double mouseX, double mouseY) {
        if (this.inUse) {
            this.playDownSound();
            this.inUse = false;
        }
    }

    @Override
    protected void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.setValueFromMouse(mouseX);
        this.inUse = true;
    }

    private void setValueFromMouse(double mouseX) {
        this.setValue((mouseX - (double)(this.getX() + 4)) / (double)(this.getWidth() - 8));
    }

    @Override
    protected int getVOffset() {
        return 0;
    }

    @Override
    protected void renderButton(PoseStack matrices, int mouseX, int mouseY, float delta) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)AbstractWidget.f_93617_);
        int vOffset = (this.isFocusedOrHovered() ? 2 : 1) * 20;
        this.m_93228_(matrices, this.getX() + (int)(this.value * (double)(this.getWidth() - 8)), this.getY(), 0, 46 + vOffset, 4, 20);
        this.m_93228_(matrices, this.getX() + (int)(this.value * (double)(this.getWidth() - 8)) + 4, this.getY(), 196, 46 + vOffset, 4, 20);
        if (!this.isMouseHovered() && this.inUse) {
            this.inUse = false;
        }
        super.renderButton(matrices, mouseX, mouseY, delta);
    }

    @Override
    protected Component getNarrationMessage() {
        return Component.m_237110_((String)"gui.narrate.slider", (Object[])new Object[]{this.getMessage()});
    }

    @Override
    protected Component getNarrationFocusedUsageMessage() {
        return Component.m_237115_((String)"narration.slider.usage.focused");
    }

    @Override
    protected Component getNarrationHoveredUsageMessage() {
        return Component.m_237115_((String)"narration.slider.usage.hovered");
    }
}

