/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.block.entity;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import snownee.kiwi.block.def.BlockDefinition;
import snownee.kiwi.block.def.SimpleBlockDefinition;
import snownee.kiwi.block.entity.BaseBlockEntity;
import snownee.kiwi.client.model.RetextureModel;
import snownee.kiwi.util.NBTHelper;

public abstract class RetextureBlockEntity
extends BaseBlockEntity {
    @Nullable
    protected Map<String, BlockDefinition> textures;
    protected ModelData modelData = ModelData.EMPTY;

    public RetextureBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos level, BlockState state, String ... textureKeys) {
        super(tileEntityTypeIn, level, state);
        this.persistData = true;
        this.textures = textureKeys.length == 0 ? null : Maps.newHashMapWithExpectedSize((int)textureKeys.length);
        for (String key : textureKeys) {
            this.textures.put(key, null);
        }
    }

    public static void setTexture(Map<String, String> textures, String key, String path) {
        if (!textures.containsKey(key)) {
            return;
        }
        textures.put(key, path);
    }

    public void setTexture(String key, BlockDefinition modelSupplier) {
        if (modelSupplier == null || !this.isValidTexture(modelSupplier)) {
            return;
        }
        RetextureBlockEntity.setTexture(this.textures, key, modelSupplier);
    }

    public boolean isValidTexture(BlockDefinition modelSupplier) {
        return true;
    }

    public static void setTexture(Map<String, BlockDefinition> textures, String key, BlockDefinition modelSupplier) {
        if (textures == null || !textures.containsKey(key)) {
            return;
        }
        textures.put(key, modelSupplier);
    }

    public static void setTexture(Map<String, BlockDefinition> textures, String key, Item item) {
        Block block = Block.m_49814_((Item)item);
        if (block != null) {
            RetextureBlockEntity.setTexture(textures, key, SimpleBlockDefinition.of(block.m_49966_()));
        }
    }

    @Override
    public void refresh() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.requestModelDataUpdate();
        } else {
            super.refresh();
        }
    }

    public void onLoad() {
        super.requestModelDataUpdate();
    }

    public void requestModelDataUpdate() {
        if (this.textures == null) {
            return;
        }
        super.requestModelDataUpdate();
        if (!this.f_58859_ && this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 8);
        }
    }

    @Override
    protected void readPacketData(CompoundTag data) {
        if (!data.m_128425_("Overrides", 10)) {
            return;
        }
        boolean shouldRefresh = RetextureBlockEntity.readTextures(this.textures, data.m_128469_("Overrides"), (Predicate<BlockDefinition>)((Predicate)this::isValidTexture));
        if (shouldRefresh) {
            this.refresh();
        }
    }

    public static boolean readTextures(Map<String, BlockDefinition> textures, CompoundTag data, Predicate<BlockDefinition> validator) {
        if (textures == null) {
            return false;
        }
        boolean shouldRefresh = false;
        NBTHelper helper = NBTHelper.of(data);
        for (String k : textures.keySet()) {
            BlockDefinition supplier;
            CompoundTag v = helper.getTag(k);
            if (v == null || (supplier = BlockDefinition.fromNBT(v)) != null && !validator.test((Object)supplier) || Objects.equals(textures.get(k), supplier)) continue;
            shouldRefresh = true;
            textures.put(k, supplier);
        }
        return shouldRefresh;
    }

    @Override
    protected CompoundTag writePacketData(CompoundTag data) {
        RetextureBlockEntity.writeTextures(this.textures, data);
        return data;
    }

    public static CompoundTag writeTextures(Map<String, BlockDefinition> textures, CompoundTag data) {
        if (textures != null) {
            NBTHelper tag = NBTHelper.of(data);
            textures.forEach((k, v) -> {
                if (v == null) {
                    return;
                }
                CompoundTag compound = new CompoundTag();
                v.save(compound);
                compound.m_128359_("Type", v.getFactory().getId());
                tag.setTag("Overrides." + k, (Tag)compound);
            });
        }
        return data;
    }

    public ModelData getModelData() {
        if (this.textures != null && this.modelData == ModelData.EMPTY) {
            this.modelData = ModelData.builder().with(RetextureModel.TEXTURES, this.textures).build();
        }
        return this.modelData;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getColor(BlockAndTintGetter level, int index) {
        return RetextureModel.getColor(this.textures, this.m_58900_(), level, this.f_58858_, index);
    }
}

