/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.types.Type;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.KiwiGO;
import snownee.kiwi.ModuleInfo;
import snownee.kiwi.block.ModBlock;
import snownee.kiwi.block.entity.TagBasedBlockEntityType;
import snownee.kiwi.loader.event.ClientInitEvent;
import snownee.kiwi.loader.event.InitEvent;
import snownee.kiwi.loader.event.PostInitEvent;
import snownee.kiwi.loader.event.ServerInitEvent;
import snownee.kiwi.mixin.ItemAccess;

public abstract class AbstractModule {
    public ResourceLocation uid;
    private static final BiConsumer<ModuleInfo, Item> ITEM_DECORATOR = (module, item) -> {
        if (module.category != null && ((ItemAccess)item).getCategory() == null && !module.noCategories.contains(item)) {
            ((ItemAccess)item).setCategory(module.category);
        }
    };
    private static final BiConsumer<ModuleInfo, Block> BLOCK_DECORATOR = (module, block) -> ModBlock.setFireInfo(block);
    private static final Map<Object, BiConsumer<ModuleInfo, ?>> DEFAULT_DECORATORS = ImmutableMap.of((Object)ForgeRegistries.ITEMS, ITEM_DECORATOR, (Object)ForgeRegistries.BLOCKS, BLOCK_DECORATOR);
    protected final Map<Object, BiConsumer<ModuleInfo, ?>> decorators = Maps.newHashMap(DEFAULT_DECORATORS);

    protected void preInit() {
    }

    protected void init(InitEvent event) {
    }

    protected void clientInit(ClientInitEvent event) {
    }

    protected void serverInit(ServerInitEvent event) {
    }

    protected void postInit(PostInitEvent event) {
    }

    protected void gatherData(GatherDataEvent event) {
    }

    protected static <T> KiwiGO<T> go(Supplier<? extends T> factory) {
        return new KiwiGO<T>(factory);
    }

    protected static <T> KiwiGO<T> go(Supplier<? extends T> factory, Supplier<Object> registry) {
        return new KiwiGO.RegistrySpecified<T>(factory, registry);
    }

    protected static Item.Properties itemProp() {
        return new Item.Properties();
    }

    protected static BlockBehaviour.Properties blockProp(Material material) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_60939_((Material)material);
        properties.m_60918_(ModBlock.deduceSoundType(material));
        properties.m_60978_(ModBlock.deduceHardness(material));
        return properties;
    }

    protected static BlockBehaviour.Properties blockProp(BlockBehaviour block) {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)block);
    }

    public static <T extends BlockEntity> KiwiGO<BlockEntityType<T>> blockEntity(BlockEntityType.BlockEntitySupplier<? extends T> factory, Type<?> datafixer, Supplier<? extends Block> ... blocks) {
        return AbstractModule.go(() -> BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)factory, (Block[])((Block[])Stream.of(blocks).map(Supplier::get).toArray(Block[]::new))).m_58966_(datafixer));
    }

    public static <T extends BlockEntity> KiwiGO<BlockEntityType<T>> blockEntity(BlockEntityType.BlockEntitySupplier<? extends T> factory, Type<?> datafixer, TagKey<Block> blockTag) {
        return AbstractModule.go(() -> new TagBasedBlockEntityType(factory, blockTag, datafixer));
    }

    public static CreativeModeTab itemCategory(String namespace, String path, final Supplier<ItemStack> icon, final @Nullable BiConsumer<List<ItemStack>, CreativeModeTab> stacksForDisplay) {
        return new CreativeModeTab(namespace + "." + path){

            public ItemStack m_6976_() {
                return (ItemStack)icon.get();
            }

            public void m_6151_(NonNullList<ItemStack> stacks) {
                if (stacksForDisplay != null) {
                    stacksForDisplay.accept(stacks, this);
                    return;
                }
                super.m_6151_(stacks);
            }
        };
    }

    public static TagKey<Item> itemTag(String namespace, String path) {
        return AbstractModule.tag(Registry.f_122904_, namespace, path);
    }

    public static TagKey<EntityType<?>> entityTag(String namespace, String path) {
        return AbstractModule.tag(Registry.f_122903_, namespace, path);
    }

    public static TagKey<Block> blockTag(String namespace, String path) {
        return AbstractModule.tag(Registry.f_122901_, namespace, path);
    }

    public static TagKey<Fluid> fluidTag(String namespace, String path) {
        return AbstractModule.tag(Registry.f_122899_, namespace, path);
    }

    public static <T> TagKey<T> tag(ResourceKey<? extends Registry<T>> registryKey, String namespace, String path) {
        return TagKey.m_203882_(registryKey, (ResourceLocation)new ResourceLocation(namespace, path));
    }

    public ResourceLocation RL(String path) {
        return new ResourceLocation(this.uid.m_135827_(), path);
    }
}

