/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.create;

import com.simibubi.create.content.logistics.filter.AttributeFilterMenu;
import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.content.logistics.filter.ItemAttribute;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import snownee.jade.addon.create.CreatePlugin;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IBoxElement;
import snownee.jade.api.ui.IBoxStyle;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.impl.ui.ScaledTextElement;

public enum FilterProvider implements IBlockComponentProvider
{
    INSTANCE;


    public ResourceLocation getUid() {
        return CreatePlugin.FILTER;
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        Item item;
        if (!accessor.showDetails() || !(accessor.getBlockEntity() instanceof SmartBlockEntity)) {
            return;
        }
        SmartBlockEntity te = (SmartBlockEntity)accessor.getBlockEntity();
        FilteringBehaviour behaviour = (FilteringBehaviour)te.getBehaviour(FilteringBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        ItemStack filter = behaviour.getFilter(accessor.getSide());
        if (filter != null && (item = filter.m_41720_()) instanceof FilterItem) {
            FilterItem item2 = (FilterItem)item;
            String key = Registry.f_122827_.m_7981_((Object)item2).toString();
            IElementHelper elements = IElementHelper.get();
            ITooltip tooltip2 = elements.tooltip();
            if ("create:filter".equals(key)) {
                boolean blacklist = filter.m_41784_().m_128471_("Blacklist");
                boolean respectNBT = filter.m_41784_().m_128471_("RespectNBT");
                MutableComponent component = blacklist ? Lang.translateDirect((String)"gui.filter.deny_list", (Object[])new Object[0]) : Lang.translateDirect((String)"gui.filter.allow_list", (Object[])new Object[0]);
                component.m_130946_("  -  ");
                component.m_7220_((Component)(respectNBT ? Lang.translateDirect((String)"gui.filter.respect_data", (Object[])new Object[0]) : Lang.translateDirect((String)"gui.filter.ignore_data", (Object[])new Object[0])));
                tooltip2.add((IElement)new ScaledTextElement((Component)component, 0.5f));
                ItemStackHandler filterItems = FilterItem.getFilterItems((ItemStack)filter);
                int count = 0;
                for (int i = 0; i < filterItems.getSlots(); ++i) {
                    ItemStack filterStack = filterItems.getStackInSlot(i);
                    if (filterStack.m_41619_()) continue;
                    IElement element = elements.item(filterStack, 0.8f);
                    if (count % 6 == 0) {
                        tooltip2.add(element);
                    } else {
                        tooltip2.append(element);
                    }
                    ++count;
                }
            } else if ("create:attribute_filter".equals(key)) {
                AttributeFilterMenu.WhitelistMode whitelistMode = AttributeFilterMenu.WhitelistMode.values()[filter.m_41784_().m_128451_("WhitelistMode")];
                MutableComponent component = whitelistMode == AttributeFilterMenu.WhitelistMode.WHITELIST_CONJ ? Lang.translateDirect((String)"gui.attribute_filter.allow_list_conjunctive", (Object[])new Object[0]) : (whitelistMode == AttributeFilterMenu.WhitelistMode.WHITELIST_DISJ ? Lang.translateDirect((String)"gui.attribute_filter.allow_list_disjunctive", (Object[])new Object[0]) : Lang.translateDirect((String)"gui.attribute_filter.deny_list", (Object[])new Object[0]));
                tooltip2.add((IElement)new ScaledTextElement((Component)component, 0.5f));
                int count = 0;
                ListTag attributes = filter.m_41784_().m_128437_("MatchedAttributes", 10);
                for (Tag inbt : attributes) {
                    CompoundTag compound = (CompoundTag)inbt;
                    ItemAttribute attribute = ItemAttribute.fromNBT((CompoundTag)compound);
                    boolean inverted = compound.m_128471_("Inverted");
                    if (count > 9) {
                        tooltip2.add((IElement)new ScaledTextElement((Component)Components.literal((String)"- ..."), 0.5f));
                        break;
                    }
                    tooltip2.add((IElement)new ScaledTextElement((Component)Components.literal((String)"- ").m_7220_((Component)attribute.format(inverted)), 0.5f));
                    ++count;
                }
            }
            if (!tooltip2.isEmpty()) {
                BoxStyle style = new BoxStyle();
                style.borderColor = -2013265920;
                style.bgColor = -2013265920;
                style.borderWidth = 0.75f;
                IBoxElement box = elements.box(tooltip2, (IBoxStyle)style);
                box.getTooltipRenderer().setPadding(0, 2.0f);
                box.getTooltipRenderer().setPadding(2, 3.0f);
                tooltip.add((IElement)box);
            }
        }
    }
}

