/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.buffer;

import codechicken.lib.render.buffer.DelegateRenderType;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;

public class VBORenderType
extends DelegateRenderType
implements AutoCloseable {
    private final BiConsumer<VertexFormat, BufferBuilder> factory;
    private final VertexBuffer vertexBuffer = new VertexBuffer();
    private final BufferBuilder builder;
    private boolean dirty = true;

    public VBORenderType(RenderType parent, BiConsumer<VertexFormat, BufferBuilder> factory) {
        super(parent, parent.m_110508_());
        this.factory = factory;
        this.builder = new BufferBuilder(this.m_110507_());
    }

    public void setDirty() {
        this.dirty = true;
    }

    public WithCallbacks withCallback(Runnable action) {
        return new WithCallbacks().withAction(action);
    }

    public WithCallbacks withState(RenderStateShard shard) {
        return new WithCallbacks().withState(shard);
    }

    private void render() {
        this.rebuild();
        this.vertexBuffer.m_166867_(RenderSystem.m_157190_(), RenderSystem.m_157192_(), RenderSystem.m_157196_());
    }

    private void rebuild() {
        if (!this.dirty) {
            return;
        }
        this.builder.m_166779_(this.m_173186_(), this.m_110508_());
        this.factory.accept(this.m_110508_(), this.builder);
        this.vertexBuffer.m_231221_(this.builder.m_231175_());
        this.builder.m_85729_();
        this.dirty = false;
    }

    @Override
    public void m_110412_(BufferBuilder buffer, int cameraX, int cameraY, int cameraZ) {
        buffer.m_231168_();
        this.m_110185_();
        this.render();
        this.m_110188_();
    }

    @Override
    public void close() throws Exception {
        this.vertexBuffer.close();
    }

    public class WithCallbacks
    extends DelegateRenderType {
        private final List<RenderStateShard> shards;

        public WithCallbacks() {
            super(VBORenderType.this);
            this.shards = new LinkedList<RenderStateShard>();
        }

        public WithCallbacks withAction(final Runnable action) {
            return this.withState(new RenderStateShard("none", SneakyUtils.none(), SneakyUtils.none()){

                public void m_110185_() {
                    action.run();
                }
            });
        }

        public WithCallbacks withState(RenderStateShard shard) {
            this.shards.add(shard);
            return this;
        }

        @Override
        public void m_110185_() {
            super.m_110185_();
            for (RenderStateShard state : this.shards) {
                state.m_110185_();
            }
        }

        @Override
        public void m_110412_(BufferBuilder buffer, int cameraX, int cameraY, int cameraZ) {
            buffer.m_231168_();
            this.m_110185_();
            VBORenderType.this.render();
            this.m_110188_();
        }

        @Override
        public void m_110188_() {
            for (RenderStateShard state : this.shards) {
                state.m_110188_();
            }
            super.m_110188_();
        }
    }
}

