/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.pipeline.transformers;

import codechicken.lib.model.IVertexConsumer;
import codechicken.lib.model.Quad;
import codechicken.lib.model.pipeline.IPipelineElementFactory;
import codechicken.lib.model.pipeline.QuadTransformer;

public class QuadTinter
extends QuadTransformer {
    public static final IPipelineElementFactory<QuadTinter> FACTORY = QuadTinter::new;
    private int tint;

    QuadTinter() {
    }

    public QuadTinter(IVertexConsumer consumer, int tint) {
        super(consumer);
        this.tint = tint;
    }

    public QuadTinter setTint(int tint) {
        this.tint = tint;
        return this;
    }

    @Override
    public boolean transform() {
        this.quad.tintIndex = -1;
        if (this.format.hasColor) {
            float r = (float)(this.tint >> 16 & 0xFF) / 255.0f;
            float g = (float)(this.tint >> 8 & 0xFF) / 255.0f;
            float b = (float)(this.tint & 0xFF) / 255.0f;
            for (Quad.Vertex v : this.quad.vertices) {
                v.color[0] = v.color[0] * r;
                v.color[1] = v.color[1] * g;
                v.color[2] = v.color[2] * b;
            }
        }
        return true;
    }
}

