/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.bakery;

import codechicken.lib.model.bakedmodels.ModelProperties;
import codechicken.lib.model.bakedmodels.PerspectiveAwareBakedModel;
import codechicken.lib.model.bakedmodels.PerspectiveAwareLayeredModel;
import codechicken.lib.model.bakery.IBakeryProvider;
import codechicken.lib.model.bakery.generation.IBlockBakery;
import codechicken.lib.model.bakery.generation.IItemBakery;
import codechicken.lib.model.bakery.key.IBlockStateKeyGenerator;
import codechicken.lib.model.bakery.key.IItemStackKeyGenerator;
import codechicken.lib.util.LogUtils;
import codechicken.lib.util.ResourceUtils;
import codechicken.lib.util.TransformUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ModelBakery {
    private static final Logger logger = LogManager.getLogger();
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("ccl.debugBakeryLogging"));
    private static final boolean FORCE_BLOCK_REBAKE = Boolean.parseBoolean(System.getProperty("ccl.debugForceBlockModelRebake"));
    private static final boolean FORCE_ITEM_REBAKE = Boolean.parseBoolean(System.getProperty("ccl.debugForceItemModelRebake"));
    private static final Cache<String, BakedModel> keyModelCache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build();
    private static final ModelProperties DEFAULT = ModelProperties.builder().withAO(true).withGui3D(true).build();
    private static final ModelProperties.PerspectiveProperties DEFAULT_PERSPECTIVE = DEFAULT.toBuilder().withTransforms(TransformUtils.DEFAULT_BLOCK).build();
    private static final Map<Item, IItemStackKeyGenerator> itemKeyGeneratorMap = Collections.synchronizedMap(new HashMap());
    private static final Map<Block, IBlockStateKeyGenerator> blockKeyGeneratorMap = Collections.synchronizedMap(new HashMap());
    private static BakedModel missingModel;
    public static final IBlockStateKeyGenerator defaultBlockKeyGenerator;
    public static final IItemStackKeyGenerator defaultItemKeyGenerator;

    public static void init() {
        ResourceUtils.registerReloadListener(e -> ModelBakery.nukeModelCache());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ModelBakery::onModelBake);
    }

    private static void onModelBake(ModelEvent.BakingCompleted event) {
        missingModel = event.getModelManager().m_119409_();
    }

    public static IBlockStateKeyGenerator getKeyGenerator(Block block) {
        if (blockKeyGeneratorMap.containsKey(block)) {
            return blockKeyGeneratorMap.get(block);
        }
        return defaultBlockKeyGenerator;
    }

    public static IItemStackKeyGenerator getKeyGenerator(Item item) {
        if (itemKeyGeneratorMap.containsKey(item)) {
            return itemKeyGeneratorMap.get(item);
        }
        return defaultItemKeyGenerator;
    }

    public static void registerBlockKeyGenerator(Block block, IBlockStateKeyGenerator generator) {
        if (blockKeyGeneratorMap.containsKey(block)) {
            throw new IllegalArgumentException("Unable to register IBlockStateKeyGenerator as one is already registered for block:" + ForgeRegistries.BLOCKS.getKey((Object)block));
        }
        blockKeyGeneratorMap.put(block, generator);
    }

    public static void registerItemKeyGenerator(Item item, IItemStackKeyGenerator generator) {
        if (itemKeyGeneratorMap.containsKey(item)) {
            throw new IllegalArgumentException("Unable to register IItemStackKeyGenerator as one is already registered for item: " + ForgeRegistries.ITEMS.getKey((Object)item));
        }
        itemKeyGeneratorMap.put(item, generator);
    }

    public static BakedModel getCachedItemModel(ItemStack stack) {
        IItemStackKeyGenerator generator = ModelBakery.getKeyGenerator(stack.m_41720_());
        String key = generator.generateKey(stack);
        BakedModel model = (BakedModel)keyModelCache.getIfPresent((Object)key);
        if (model == null || FORCE_ITEM_REBAKE) {
            try {
                model = ModelBakery.timeModelGeneration(ModelBakery::generateItemModel, stack, "ITEM: " + key);
            }
            catch (Throwable t) {
                LogUtils.errorOnce(logger, t, "ItemBaking", "Fatal exception thrown whilst baking item model for: " + stack, new Object[0]);
                return missingModel;
            }
            if (model != missingModel) {
                keyModelCache.put((Object)key, (Object)model);
            }
        }
        return model;
    }

    public static BakedModel generateItemModel(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof IBakeryProvider) {
            IBakeryProvider bakeryProvider = (IBakeryProvider)item;
            IItemBakery bakery = (IItemBakery)bakeryProvider.getBakery();
            List<BakedQuad> unculledQuads = List.copyOf(bakery.bakeItemQuads(null, stack));
            HashMap<Direction, List<BakedQuad>> faceQuads = new HashMap<Direction, List<BakedQuad>>();
            for (Direction face : Direction.f_122348_) {
                faceQuads.put(face, List.copyOf(bakery.bakeItemQuads(face, stack)));
            }
            ModelProperties.PerspectiveProperties properties = bakery.getModelProperties(stack);
            return new PerspectiveAwareBakedModel(faceQuads, unculledQuads, properties);
        }
        return missingModel;
    }

    public static BakedModel getCachedModel(BlockState state, ModelData data) {
        if (state == null) {
            return missingModel;
        }
        IBlockStateKeyGenerator keyGenerator = ModelBakery.getKeyGenerator(state.m_60734_());
        String key = keyGenerator.generateKey(state, data);
        BakedModel model = (BakedModel)keyModelCache.getIfPresent((Object)key);
        if (model == null || FORCE_BLOCK_REBAKE) {
            try {
                model = ModelBakery.timeModelGeneration(ModelBakery::generateModel, state, data, "BLOCK: " + key);
            }
            catch (Throwable t) {
                LogUtils.errorOnce(logger, t, "BlockBaking", "Fatal exception thrown whilst baking block model for: " + state, new Object[0]);
                return missingModel;
            }
            if (model != missingModel) {
                keyModelCache.put((Object)key, (Object)model);
            }
        }
        return model;
    }

    public static BakedModel generateModel(BlockState state, ModelData data) {
        Block block = state.m_60734_();
        if (block instanceof IBakeryProvider) {
            IBakeryProvider bakeryProvider = (IBakeryProvider)block;
            IBlockBakery bakery = (IBlockBakery)bakeryProvider.getBakery();
            ChunkRenderTypeSet layers = bakery.getBlockRenderLayers();
            HashMap<RenderType, List<BakedQuad>> unculledQuads = new HashMap<RenderType, List<BakedQuad>>();
            HashMap<RenderType, Map<Direction, List<BakedQuad>>> culledQuads = new HashMap<RenderType, Map<Direction, List<BakedQuad>>>();
            for (RenderType layer : layers) {
                unculledQuads.put(layer, List.copyOf(bakery.bakeFace(null, layer, state, data)));
                HashMap<Direction, List<BakedQuad>> faceQuadMap = new HashMap<Direction, List<BakedQuad>>();
                for (Direction face : Direction.f_122348_) {
                    faceQuadMap.put(face, List.copyOf(bakery.bakeFace(face, layer, state, data)));
                }
                culledQuads.put(layer, faceQuadMap);
            }
            return new PerspectiveAwareLayeredModel(culledQuads, unculledQuads, DEFAULT_PERSPECTIVE, RenderType.m_110451_());
        }
        return missingModel;
    }

    private static <T, R> R timeModelGeneration(Function<T, R> func, T thing, String logPostfix) {
        if (DEBUG) {
            logger.info("Baking Model.. Key: {}", (Object)logPostfix);
        }
        long start = System.nanoTime();
        R ret = func.apply(thing);
        long end = System.nanoTime();
        ModelBakery.logGenTime(start, end);
        return ret;
    }

    private static <T, U, R> R timeModelGeneration(BiFunction<T, U, R> func, T thing, U thing2, String logPostfix) {
        if (DEBUG) {
            logger.info("Baking Model.. Key: {}", (Object)logPostfix);
        }
        long start = System.nanoTime();
        R ret = func.apply(thing, thing2);
        long end = System.nanoTime();
        ModelBakery.logGenTime(start, end);
        return ret;
    }

    private static void logGenTime(long start, long end) {
        if (DEBUG) {
            long delta = end - start;
            long millis = TimeUnit.NANOSECONDS.toMillis(delta);
            String s = millis >= 5L ? millis + "ms" : delta + "ns";
            logger.info("Baking finished in {}.", (Object)s);
        }
    }

    public static void nukeModelCache() {
        keyModelCache.invalidateAll();
    }

    static {
        defaultBlockKeyGenerator = (state, data) -> state.toString();
        defaultItemKeyGenerator = stack -> ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString() + "|" + stack.m_41773_();
    }
}

