/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.world;

import codechicken.chunkloader.api.IChunkLoader;
import codechicken.chunkloader.world.ChunkLoaderHandler;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;

public class Organiser {
    public final Set<BlockPos> dormantLoaders = new HashSet<BlockPos>();
    public final Map<ChunkPos, List<IChunkLoader>> forcedChunksByChunk = new HashMap<ChunkPos, List<IChunkLoader>>();
    public final Map<IChunkLoader, Set<ChunkPos>> forcedChunksByLoader = new HashMap<IChunkLoader, Set<ChunkPos>>();
    public final Map<IChunkLoader, Object2IntMap<ChunkPos>> timedUnloadQueue = new HashMap<IChunkLoader, Object2IntMap<ChunkPos>>();
    public final List<IChunkLoader> pendingLoaders = new LinkedList<IChunkLoader>();
    private final ChunkLoaderHandler handler;
    public final ResourceLocation dim;
    public final UUID player;
    public boolean reviving;
    public boolean dormant = false;

    public Organiser(ChunkLoaderHandler handler, ResourceLocation dim, UUID player) {
        this.handler = handler;
        this.dim = dim;
        this.player = player;
    }

    public boolean isEmpty() {
        return this.dormantLoaders.isEmpty() && this.forcedChunksByLoader.isEmpty();
    }

    public CompoundTag write(CompoundTag tag) {
        tag.m_128365_("dormantLoaders", (Tag)this.dormantLoaders.stream().map(NbtUtils::m_129224_).collect(Collectors.toCollection(ListTag::new)));
        tag.m_128365_("loaders", (Tag)this.forcedChunksByLoader.keySet().stream().map(IChunkLoader::pos).map(NbtUtils::m_129224_).collect(Collectors.toCollection(ListTag::new)));
        return tag;
    }

    public Organiser read(CompoundTag tag) {
        tag.m_128437_("dormantLoaders", 10).stream().map(e -> (CompoundTag)e).map(NbtUtils::m_129239_).forEach(this.dormantLoaders::add);
        tag.m_128437_("loaders", 10).stream().map(e -> (CompoundTag)e).map(NbtUtils::m_129239_).forEach(this.dormantLoaders::add);
        this.dormant = true;
        return this;
    }

    public void addChunkLoader(IChunkLoader loader) {
        if (this.reviving) {
            return;
        }
        if (this.dormant) {
            this.dormantLoaders.add(loader.pos());
        } else {
            this.pendingLoaders.add(loader);
        }
    }

    public void remChunkLoader(IChunkLoader loader) {
        if (this.dormant) {
            this.dormantLoaders.remove(loader.pos());
        } else {
            Set<ChunkPos> chunks = this.forcedChunksByLoader.remove(loader);
            if (chunks == null) {
                return;
            }
            this.unforceChunks(loader, chunks, true);
        }
    }

    public void forceChunks(IChunkLoader loader, Set<ChunkPos> chunks) {
        for (ChunkPos chunk : chunks) {
            this.handler.addChunk(loader, this.dim, chunk);
            List loaders = this.forcedChunksByChunk.computeIfAbsent(chunk, e -> new LinkedList());
            if (loaders.contains(loader)) continue;
            loaders.add(loader);
        }
        this.forcedChunksByLoader.put(loader, chunks);
    }

    public void unforceChunks(IChunkLoader loader, Set<ChunkPos> chunks, boolean remLoader) {
        for (ChunkPos chunk : chunks) {
            Object2IntMap unloadQueue = this.timedUnloadQueue.computeIfAbsent(loader, e -> new Object2IntOpenHashMap());
            unloadQueue.put((Object)chunk, 100);
            List<IChunkLoader> loaders = this.forcedChunksByChunk.get(chunk);
            if (loaders == null) continue;
            loaders.remove(loader);
            if (!loaders.isEmpty()) continue;
            this.forcedChunksByChunk.remove(chunk);
        }
        if (!remLoader) {
            this.forcedChunksByLoader.get(loader).removeAll(chunks);
        }
    }

    public void devive() {
        if (this.dormant) {
            return;
        }
        for (IChunkLoader loader : ImmutableSet.copyOf(this.forcedChunksByLoader.keySet())) {
            this.dormantLoaders.add(loader.pos());
            this.handler.removeChunkLoader(loader);
        }
        this.dormant = true;
    }

    public void revive(ServerLevel world) {
        if (!this.dormant) {
            return;
        }
        this.dormant = false;
        if (this.dormantLoaders.isEmpty()) {
            return;
        }
        HashSet<BlockPos> dormantLoaders = new HashSet<BlockPos>(this.dormantLoaders);
        this.dormantLoaders.clear();
        for (BlockPos pos : dormantLoaders) {
            this.reviving = true;
            BlockEntity tile = world.m_7702_(pos);
            this.reviving = false;
            if (!(tile instanceof IChunkLoader)) continue;
            this.handler.addChunkLoader((IChunkLoader)tile);
        }
    }

    public void updateLoader(IChunkLoader loader) {
        Set<ChunkPos> loadedChunks = this.forcedChunksByLoader.get(loader);
        if (loadedChunks == null) {
            this.addChunkLoader(loader);
            return;
        }
        HashSet<ChunkPos> oldChunks = new HashSet<ChunkPos>(loadedChunks);
        HashSet<ChunkPos> newChunks = new HashSet<ChunkPos>();
        for (ChunkPos chunk : loader.getChunks()) {
            if (oldChunks.remove(chunk)) continue;
            newChunks.add(chunk);
        }
        if (!oldChunks.isEmpty()) {
            this.unforceChunks(loader, oldChunks, false);
        }
        if (!newChunks.isEmpty()) {
            this.forceChunks(loader, newChunks);
        }
    }

    public void onTickEnd() {
        this.tickLoads();
        this.tickUnloads();
    }

    public void tickLoads() {
        if (!this.pendingLoaders.isEmpty()) {
            ArrayList<IChunkLoader> loaders = new ArrayList<IChunkLoader>(this.pendingLoaders);
            this.pendingLoaders.clear();
            for (IChunkLoader loader : loaders) {
                this.forceChunks(loader, loader.getChunks());
            }
        }
    }

    public void tickUnloads() {
        this.timedUnloadQueue.entrySet().removeIf(loaderEntry -> {
            Object2IntMap map = (Object2IntMap)loaderEntry.getValue();
            map.object2IntEntrySet().removeIf(chunkEntry -> {
                int ticks = chunkEntry.getIntValue();
                if (ticks <= 1) {
                    this.handler.remChunk((IChunkLoader)loaderEntry.getKey(), this.dim, (ChunkPos)chunkEntry.getKey());
                    return true;
                }
                chunkEntry.setValue(ticks - 1);
                return false;
            });
            return map.isEmpty();
        });
    }
}

