/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.command;

import codechicken.chunkloader.handler.ChickenChunksConfig;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;

public class ChickenChunksCommand {
    private static final String RESTRICTIONS_RESET_FOR = "chickenchunks:commands.restrictions.player.reset";
    private static final String OFFLINE_ENABLE_FOR = "chickenchunks:commands.restrictions.player.offline.enable";
    private static final String OFFLINE_DISABLE_FOR = "chickenchunks:commands.restrictions.player.offline.disable";
    private static final String OFFLINE_RESET_FOR = "chickenchunks:commands.restrictions.player.offline.reset";
    private static final String TIMEOUT_SET_FOR = "chickenchunks:commands.restrictions.player.timeout.set";
    private static final String TIMEOUT_RESET_FOR = "chickenchunks:commands.restrictions.player.timeout.reset";
    private static final String ALLOWED_CHUNKS_SET_FOR = "chickenchunks:commands.restrictions.player.allowed_chunks.set";
    private static final String ALLOWED_CHUNKS_RESET_FOR = "chickenchunks:commands.restrictions.player.allowed_chunks.reset";
    private static final String CHUNKS_PER_LOADER_SET_FOR = "chickenchunks:commands.restrictions.player.chunks_per_loader.set";
    private static final String CHUNKS_PER_LOADER_RESET_FOR = "chickenchunks:commands.restrictions.player.chunks_per_loader.reset";

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(ChickenChunksCommand::onRegisterCommands);
    }

    private static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"chickenchunks").requires(e -> e.m_6761_(4))).then(Commands.m_82127_((String)"restrict").then(Commands.m_82127_((String)"player").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"players", (ArgumentType)GameProfileArgument.m_94584_()).then(Commands.m_82127_((String)"reset").executes(ChickenChunksCommand::resetRestrictions))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"allow_offline").then(Commands.m_82127_((String)"toggle").executes(ChickenChunksCommand::toggleOfflineFor))).then(Commands.m_82127_((String)"enable").executes(ChickenChunksCommand::enableOfflineFor))).then(Commands.m_82127_((String)"disable").executes(ChickenChunksCommand::disableOfflineFor))).then(Commands.m_82127_((String)"reset").executes(ChickenChunksCommand::resetOfflineFor)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"offline_timeout").then(Commands.m_82129_((String)"timeout", (ArgumentType)IntegerArgumentType.integer()).executes(ChickenChunksCommand::setTimeoutFor))).then(Commands.m_82127_((String)"reset").executes(ChickenChunksCommand::resetTimeoutFor)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"allowed_chunks").then(Commands.m_82129_((String)"allowed_chunks", (ArgumentType)IntegerArgumentType.integer()).executes(ChickenChunksCommand::setAllowedChunksFor))).then(Commands.m_82127_((String)"reset").executes(ChickenChunksCommand::resetAllowedChunksFor)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"chunks_per_loader").then(Commands.m_82129_((String)"chunks_per_loader", (ArgumentType)IntegerArgumentType.integer()).executes(ChickenChunksCommand::setChunksPerLoaderFor))).then(Commands.m_82127_((String)"reset").executes(ChickenChunksCommand::resetChunksPerLoaderFor)))))));
    }

    private static int resetRestrictions(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        Collection profiles = GameProfileArgument.m_94590_(ctx, (String)"players");
        for (GameProfile profile : profiles) {
            ChickenChunksConfig.resetRestrictions(profile.getId());
            src.m_81354_((Component)Component.m_237110_((String)RESTRICTIONS_RESET_FOR, (Object[])new Object[]{profile.getName()}), true);
        }
        return profiles.size();
    }

    private static int toggleOfflineFor(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        Collection profiles = GameProfileArgument.m_94590_(ctx, (String)"players");
        for (GameProfile profile : profiles) {
            ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getOrCreateRestrictions(profile.getId());
            boolean state = !restrictions.canLoadOffline();
            restrictions.setAllowOffline(state);
            src.m_81354_((Component)Component.m_237110_((String)(state ? OFFLINE_ENABLE_FOR : OFFLINE_DISABLE_FOR), (Object[])new Object[]{profile.getName()}), true);
        }
        return profiles.size();
    }

    private static int enableOfflineFor(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return ChickenChunksCommand.setOfflineFor(ctx, true);
    }

    private static int disableOfflineFor(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return ChickenChunksCommand.setOfflineFor(ctx, false);
    }

    private static int setOfflineFor(CommandContext<CommandSourceStack> ctx, boolean state) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        Collection profiles = GameProfileArgument.m_94590_(ctx, (String)"players");
        for (GameProfile profile : profiles) {
            ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getOrCreateRestrictions(profile.getId());
            restrictions.setAllowOffline(state);
            src.m_81354_((Component)Component.m_237110_((String)(state ? OFFLINE_ENABLE_FOR : OFFLINE_DISABLE_FOR), (Object[])new Object[]{profile.getName()}), true);
        }
        return profiles.size();
    }

    private static int resetOfflineFor(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        Collection profiles = GameProfileArgument.m_94590_(ctx, (String)"players");
        for (GameProfile profile : profiles) {
            ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getOrCreateRestrictions(profile.getId());
            restrictions.remAllowOffline();
            src.m_81354_((Component)Component.m_237110_((String)OFFLINE_RESET_FOR, (Object[])new Object[]{profile.getName()}), true);
        }
        return profiles.size();
    }

    public static int setTimeoutFor(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        Collection profiles = GameProfileArgument.m_94590_(ctx, (String)"players");
        int timeout = IntegerArgumentType.getInteger(ctx, (String)"timeout");
        for (GameProfile profile : profiles) {
            ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getOrCreateRestrictions(profile.getId());
            restrictions.setOfflineTimeout(timeout);
            src.m_81354_((Component)Component.m_237110_((String)TIMEOUT_SET_FOR, (Object[])new Object[]{profile.getName(), timeout}), true);
        }
        return profiles.size();
    }

    private static int resetTimeoutFor(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        Collection profiles = GameProfileArgument.m_94590_(ctx, (String)"players");
        for (GameProfile profile : profiles) {
            ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getOrCreateRestrictions(profile.getId());
            restrictions.remOfflineTimeout();
            src.m_81354_((Component)Component.m_237110_((String)TIMEOUT_RESET_FOR, (Object[])new Object[]{profile.getName()}), true);
        }
        return profiles.size();
    }

    public static int setAllowedChunksFor(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        Collection profiles = GameProfileArgument.m_94590_(ctx, (String)"players");
        int chunks = IntegerArgumentType.getInteger(ctx, (String)"allowed_chunks");
        for (GameProfile profile : profiles) {
            ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getOrCreateRestrictions(profile.getId());
            restrictions.setTotalAllowedChunks(chunks);
            src.m_81354_((Component)Component.m_237110_((String)ALLOWED_CHUNKS_SET_FOR, (Object[])new Object[]{profile.getName(), chunks}), true);
        }
        return profiles.size();
    }

    private static int resetAllowedChunksFor(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        Collection profiles = GameProfileArgument.m_94590_(ctx, (String)"players");
        for (GameProfile profile : profiles) {
            ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getOrCreateRestrictions(profile.getId());
            restrictions.remTotalAllowedChunks();
            src.m_81354_((Component)Component.m_237110_((String)ALLOWED_CHUNKS_RESET_FOR, (Object[])new Object[]{profile.getName()}), true);
        }
        return profiles.size();
    }

    public static int setChunksPerLoaderFor(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        Collection profiles = GameProfileArgument.m_94590_(ctx, (String)"players");
        int chunks = IntegerArgumentType.getInteger(ctx, (String)"chunks_per_loader");
        for (GameProfile profile : profiles) {
            ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getOrCreateRestrictions(profile.getId());
            restrictions.setChunksPerLoader(chunks);
            src.m_81354_((Component)Component.m_237110_((String)CHUNKS_PER_LOADER_SET_FOR, (Object[])new Object[]{profile.getName(), chunks}), true);
        }
        return profiles.size();
    }

    private static int resetChunksPerLoaderFor(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        Collection profiles = GameProfileArgument.m_94590_(ctx, (String)"players");
        for (GameProfile profile : profiles) {
            ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getOrCreateRestrictions(profile.getId());
            restrictions.remChunksPerLoader();
            src.m_81354_((Component)Component.m_237110_((String)CHUNKS_PER_LOADER_RESET_FOR, (Object[])new Object[]{profile.getName()}), true);
        }
        return profiles.size();
    }

    private static ChickenChunksConfig.Restrictions getPlayerRestrictions(UUID player) {
        return ChickenChunksConfig.getOrCreateRestrictions(player);
    }
}

