/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.api;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.ChunkPos;

public enum ChunkLoaderShape {
    SQUARE("square"),
    CIRCLE("circle"),
    LINE_X("linex"),
    LINE_Z("linez");

    private final String name;
    private static final ChunkLoaderShape[] VALUES;
    private static final ChunkLoaderShape[] NEXT_LOOKUP;
    private static final ChunkLoaderShape[] PREV_LOOKUP;

    private ChunkLoaderShape(String s) {
        this.name = s;
    }

    public ChunkLoaderShape next() {
        return NEXT_LOOKUP[this.ordinal()];
    }

    public ChunkLoaderShape prev() {
        return PREV_LOOKUP[this.ordinal()];
    }

    public Set<ChunkPos> getLoadedChunks(int chunkx, int chunkz, int radius) {
        HashSet<ChunkPos> chunks = new HashSet<ChunkPos>();
        switch (this) {
            case SQUARE: {
                for (int cx = chunkx - radius; cx <= chunkx + radius; ++cx) {
                    for (int cz = chunkz - radius; cz <= chunkz + radius; ++cz) {
                        chunks.add(new ChunkPos(cx, cz));
                    }
                }
                break;
            }
            case LINE_X: {
                for (int cx = chunkx - radius; cx <= chunkx + radius; ++cx) {
                    chunks.add(new ChunkPos(cx, chunkz));
                }
                break;
            }
            case LINE_Z: {
                for (int cz = chunkz - radius; cz <= chunkz + radius; ++cz) {
                    chunks.add(new ChunkPos(chunkx, cz));
                }
                break;
            }
            case CIRCLE: {
                for (int cx = chunkx - radius; cx <= chunkx + radius; ++cx) {
                    for (int cz = chunkz - radius; cz <= chunkz + radius; ++cz) {
                        double distSquared = (cx - chunkx) * (cx - chunkx) + (cz - chunkz) * (cz - chunkz);
                        if (!(distSquared <= (double)(radius * radius))) continue;
                        chunks.add(new ChunkPos(cx, cz));
                    }
                }
                break;
            }
        }
        return chunks;
    }

    public Component getTranslation() {
        return Component.m_237115_((String)("chickenchunks.shape." + this.name));
    }

    static {
        VALUES = ChunkLoaderShape.values();
        NEXT_LOOKUP = (ChunkLoaderShape[])Arrays.stream(VALUES).map(e -> VALUES[(e.ordinal() + 1) % VALUES.length]).toArray(ChunkLoaderShape[]::new);
        PREV_LOOKUP = (ChunkLoaderShape[])Arrays.stream(VALUES).map(e -> VALUES[Math.floorMod(e.ordinal() - 1, VALUES.length)]).toArray(ChunkLoaderShape[]::new);
    }
}

