/*
 * Decompiled with CFR 0.152.
 */
package com.github.bakycoder.backtobed.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class TooltipUtils {
    private static final int MAX_TEXT_LINE_LENGTH = 28;

    public static List<Component> formatComponent(String key, ChatFormatting style, boolean newLineAtEnd) {
        ArrayList<Component> tooltipLines = new ArrayList<Component>();
        String text = I18n.m_118938_((String)key, (Object[])new Object[0]);
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        if (!currentLine.isEmpty()) {
            tooltipLines.add((Component)Component.m_237113_((String)currentLine.toString()).m_130940_(style));
        }
        for (String word : words) {
            if (currentLine.length() + word.length() + 1 <= 28) {
                if (!currentLine.isEmpty()) {
                    currentLine.append(" ");
                }
                currentLine.append(word);
                continue;
            }
            tooltipLines.add((Component)Component.m_237113_((String)currentLine.toString()).m_130940_(style));
            currentLine = new StringBuilder(word);
        }
        if (!currentLine.isEmpty()) {
            tooltipLines.add((Component)Component.m_237113_((String)currentLine.toString()).m_130940_(style));
        }
        if (newLineAtEnd) {
            tooltipLines.add((Component)Component.m_237113_((String)""));
        }
        return tooltipLines;
    }

    public static List<Component> formatComponent(String key, ChatFormatting style) {
        return TooltipUtils.formatComponent(key, style, false);
    }

    public static MutableComponent highlightComponentArg(String key, String arg, ChatFormatting keyStyle, ChatFormatting argStyle) {
        String text = I18n.m_118938_((String)key, (Object[])new Object[0]);
        MutableComponent textComponent = Component.m_237113_((String)String.format(text, arg));
        int argStart = textComponent.getString().indexOf(arg);
        MutableComponent argComponent = Component.m_237113_((String)arg).m_130940_(argStyle);
        MutableComponent textBeforeArg = Component.m_237113_((String)textComponent.getString().substring(0, argStart)).m_130940_(keyStyle);
        MutableComponent textAfterArg = Component.m_237113_((String)textComponent.getString().substring(argStart + arg.length())).m_130940_(keyStyle);
        return textBeforeArg.m_7220_((Component)argComponent).m_7220_((Component)textAfterArg);
    }
}

