/*
 * Decompiled with CFR 0.152.
 */
package com.github.bakycoder.backtobed.item;

import com.github.bakycoder.backtobed.utils.TooltipUtils;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MagicalReturner
extends Item {
    public static final String ITEM_NAME = "magical_returner";
    private static final int ITEM_DURATION_USAGE_TICKS = 40;
    private static final int ITEM_COOLDOWN_TICKS = 40;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);

    public MagicalReturner() {
        super(new Item.Properties().m_41491_(CreativeModeTab.f_40756_).m_41487_(1));
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, list, tooltipFlag);
        list.addAll(TooltipUtils.formatComponent("item.backtobed.magical_returner.tooltip.behavior", ChatFormatting.GRAY, true));
        if (Screen.m_96638_()) {
            list.addAll(TooltipUtils.formatComponent("item.backtobed.magical_returner.tooltip.further", ChatFormatting.GREEN));
        } else {
            list.add((Component)TooltipUtils.highlightComponentArg("backtobed.tooltip.key_hold", "SHIFT", ChatFormatting.YELLOW, ChatFormatting.GOLD));
        }
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack itemStack, int i) {
        BlockPos respawnPos;
        ServerPlayer player;
        block11: {
            block10: {
                super.m_5929_(level, livingEntity, itemStack, i);
                if (!(livingEntity instanceof ServerPlayer)) break block10;
                player = (ServerPlayer)livingEntity;
                if (!level.m_5776_()) break block11;
            }
            return;
        }
        int duration = this.m_8105_(itemStack) - i;
        if (duration < 40) {
            return;
        }
        if (player.m_20193_().m_46472_() != Level.f_46428_) {
            player.m_5661_((Component)Component.m_237115_((String)"item.backtobed.magical_returner.condition.teleport_for_overworld"), true);
            player.m_5810_();
            player.m_36335_().m_41524_((Item)this, 40);
        }
        if ((respawnPos = player.m_8961_()) == null) {
            player.m_5661_((Component)Component.m_237115_((String)"item.backtobed.magical_returner.condition.no_respawn_point"), true);
            player.m_5810_();
            player.m_36335_().m_41524_((Item)this, 40);
            return;
        }
        if (level.m_8055_(respawnPos).m_60734_() instanceof BedBlock) {
            double destinationX = (double)respawnPos.m_123341_() + 0.5;
            double destinationY = (double)respawnPos.m_123342_() + 0.6;
            double destinationZ = (double)respawnPos.m_123343_() + 0.5;
            if (player.m_20202_() != null) {
                Entity riddenEntity = player.m_20202_();
                player.m_8127_();
                this.executor.schedule(() -> {
                    assert (riddenEntity != null);
                    riddenEntity.m_6021_(destinationX, destinationY, destinationZ);
                }, 100L, TimeUnit.MILLISECONDS);
                player.m_6021_(destinationX, destinationY, destinationZ);
            } else {
                player.m_6021_(destinationX, destinationY, destinationZ);
            }
            level.m_5594_(null, respawnPos, SoundEvents.f_144052_, SoundSource.PLAYERS, 1.0f, 1.0f);
            DustColorTransitionOptions dustColorTransitionOptions = new DustColorTransitionOptions(new Vector3f(0.0f, 1.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), 1.0f);
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8624_(player, (ParticleOptions)dustColorTransitionOptions, true, (double)respawnPos.m_123341_() + 0.5, (double)respawnPos.m_123342_() + 0.6, (double)respawnPos.m_123343_() + 0.5, 85, 0.85, 0.75, 0.85, 0.005);
        } else {
            player.m_5661_((Component)Component.m_237115_((String)"item.backtobed.magical_returner.condition.no_access_to_bed"), true);
        }
        player.m_5810_();
        player.m_36335_().m_41524_((Item)this, 40);
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.BOW;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level worldIn, Player playerIn, @NotNull InteractionHand handIn) {
        playerIn.m_6672_(handIn);
        return InteractionResultHolder.m_19096_((Object)playerIn.m_21120_(handIn));
    }
}

