/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics.world;

import com.sonicether.soundphysics.world.ClonedLevelHeightAccessor;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.TickContainerAccess;

public class ClonedLevelChunk
extends ChunkAccess {
    private final LevelChunkTicks<Block> blockTicks;
    private final LevelChunkTicks<Fluid> fluidTicks;

    public ClonedLevelChunk(Level level, ChunkPos chunkPos, @Nullable LevelChunkSection[] levelChunkSections) {
        super(chunkPos, null, (LevelHeightAccessor)new ClonedLevelHeightAccessor(level), BuiltinRegistries.f_123865_, 0L, levelChunkSections, null);
        for (Heightmap.Types types : Heightmap.Types.values()) {
            if (!ChunkStatus.f_62326_.m_62500_().contains(types)) continue;
            this.f_187608_.put(types, new Heightmap((ChunkAccess)this, types));
        }
        this.blockTicks = new LevelChunkTicks();
        this.fluidTicks = new LevelChunkTicks();
    }

    public BlockEntity m_7702_(@Nonnull BlockPos blockPos) {
        return (BlockEntity)this.f_187610_.get(blockPos);
    }

    public BlockState m_8055_(@Nonnull BlockPos blockPos) {
        return this.withLevelChunkSectionAtPosition(blockPos, section -> {
            if (section == null || section.m_188008_()) {
                return Blocks.f_50016_.m_49966_();
            }
            return section.m_62982_(blockPos.m_123341_() & 0xF, blockPos.m_123342_() & 0xF, blockPos.m_123343_() & 0xF);
        });
    }

    public FluidState m_6425_(@Nonnull BlockPos blockPos) {
        return this.withLevelChunkSectionAtPosition(blockPos, section -> {
            if (section == null || section.m_188008_()) {
                return Fluids.f_76191_.m_76145_();
            }
            return section.m_63007_(blockPos.m_123341_() & 0xF, blockPos.m_123342_() & 0xF, blockPos.m_123343_() & 0xF);
        });
    }

    private <T> T withLevelChunkSectionAtPosition(BlockPos blockPos, Function<LevelChunkSection, T> block) {
        try {
            int sectionIndex = this.m_151564_(blockPos.m_123342_());
            if (sectionIndex >= 0 && sectionIndex < this.f_187612_.length) {
                LevelChunkSection section = this.f_187612_[sectionIndex];
                return block.apply(section);
            }
            return block.apply(null);
        }
        catch (Throwable exception) {
            CrashReport crashReport = CrashReport.m_127521_((Throwable)exception, (String)"Getting section in cloned level chunk");
            CrashReportCategory crashReportCategory = crashReport.m_127514_("Chunk Section Get");
            crashReportCategory.m_128165_("Location", () -> CrashReportCategory.m_178942_((LevelHeightAccessor)this, (int)blockPos.m_123341_(), (int)blockPos.m_123342_(), (int)blockPos.m_123343_()));
            throw new ReportedException(crashReport);
        }
    }

    public TickContainerAccess<Block> m_183531_() {
        return this.blockTicks;
    }

    public TickContainerAccess<Fluid> m_183526_() {
        return this.fluidTicks;
    }

    public ChunkAccess.TicksToSave m_183568_() {
        return new ChunkAccess.TicksToSave(this.blockTicks, this.fluidTicks);
    }

    public ChunkStatus m_6415_() {
        return ChunkStatus.f_62326_;
    }

    public Stream<BlockPos> m_6267_() {
        return Stream.empty();
    }

    public void m_6286_(@Nonnull Entity entity) {
        throw new UnsupportedOperationException("Can not add entity to read-only level clone");
    }

    public CompoundTag m_8051_(@Nonnull BlockPos blockPos) {
        throw new UnsupportedOperationException("Can not read block entity NBT data from read-only level clone");
    }

    public void m_8114_(@Nonnull BlockPos blockPos) {
        throw new UnsupportedOperationException("Can not remove entity from read-only level clone");
    }

    public void m_142169_(@Nonnull BlockEntity blockEntity) {
        throw new UnsupportedOperationException("Can not set block entity in read-only level clone");
    }

    public BlockState m_6978_(@Nonnull BlockPos blockPos, @Nonnull BlockState blockState, boolean unknownFlag) {
        throw new UnsupportedOperationException("Can not set block state in read-only level clone");
    }
}

