/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item.bauble;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidAttackEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.tartaricacid.touhoulittlemaid.util.TeleportHelper;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class NimbleFabricBauble
implements IMaidBauble {
    private static final int MAX_RETRY = 16;

    public NimbleFabricBauble() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLivingDamage(MaidAttackEvent event) {
        int slot;
        EntityMaid maid = event.getMaid();
        DamageSource source = event.getSource();
        if (source.m_269533_(DamageTypeTags.f_268524_) && (slot = ItemsUtil.getBaubleSlotInMaid(maid, this)) >= 0) {
            event.setCanceled(true);
            ItemStack stack = maid.getMaidBauble().getStackInSlot(slot);
            stack.m_41622_(1, (LivingEntity)maid, m -> maid.sendItemBreakMessage(stack));
            maid.getMaidBauble().setStackInSlot(slot, stack);
            for (int i = 0; i < 16; ++i) {
                if (!TeleportHelper.teleport(maid)) continue;
                return;
            }
        }
    }
}

