/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.core.processor;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.AnimatableEntity;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.controller.AnimationController;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.predicate.AnimationEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.keyframe.AnimationPoint;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.keyframe.BoneAnimationQueue;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.manager.AnimationData;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.MolangParser;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.processor.IBone;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.processor.PointData;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.snapshot.BoneSnapshot;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.snapshot.BoneTopLevelSnapshot;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.util.MathUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;

public class AnimationProcessor<T extends AnimatableEntity> {
    private final Map<String, BoneTopLevelSnapshot> boneMap = new Object2ObjectOpenHashMap();
    private final T animatable;
    private boolean reloadAnimations = false;
    private boolean modelDirty = false;

    public AnimationProcessor(T animatable) {
        this.animatable = animatable;
    }

    public void tickAnimation(double seekTime, AnimationEvent event, MolangParser parser) {
        AnimationData manager = ((AnimatableEntity)this.animatable).getAnimationData();
        for (AnimationController controller : manager.getAnimationControllers().values()) {
            if (this.reloadAnimations) {
                controller.markNeedsReload();
                controller.getBoneAnimationQueues().clear();
            }
            controller.isJustStarting = manager.isFirstTick;
            event.setController(controller);
            controller.process(seekTime, event, this.boneMap, parser, this.modelDirty);
            boolean isParallelController = controller.getName().startsWith("parallel_");
            for (BoneAnimationQueue boneAnimation : controller.getBoneAnimationQueues()) {
                BoneTopLevelSnapshot snapshot = boneAnimation.topLevelSnapshot;
                BoneSnapshot initialSnapshot = snapshot.bone.getInitialSnapshot();
                PointData pointData = snapshot.cachedPointData;
                AnimationPoint rXPoint = (AnimationPoint)boneAnimation.rotationXQueue().poll();
                AnimationPoint rYPoint = (AnimationPoint)boneAnimation.rotationYQueue().poll();
                AnimationPoint rZPoint = (AnimationPoint)boneAnimation.rotationZQueue().poll();
                if (rXPoint != null && rYPoint != null && rZPoint != null) {
                    float valueX = MathUtil.lerpValues(rXPoint, controller.easingType, (Function<Double, Double>)controller.customEasingMethod);
                    float valueY = MathUtil.lerpValues(rYPoint, controller.easingType, (Function<Double, Double>)controller.customEasingMethod);
                    float valueZ = MathUtil.lerpValues(rZPoint, controller.easingType, (Function<Double, Double>)controller.customEasingMethod);
                    pointData.rotationValueX += valueX;
                    pointData.rotationValueY += valueY;
                    pointData.rotationValueZ += valueZ;
                    if (isParallelController) {
                        snapshot.rotationValueX = pointData.rotationValueX + initialSnapshot.rotationValueX;
                        snapshot.rotationValueY = pointData.rotationValueY + initialSnapshot.rotationValueY;
                        snapshot.rotationValueZ = pointData.rotationValueZ + initialSnapshot.rotationValueZ;
                    } else {
                        snapshot.rotationValueX = valueX + initialSnapshot.rotationValueX;
                        snapshot.rotationValueY = valueY + initialSnapshot.rotationValueY;
                        snapshot.rotationValueZ = valueZ + initialSnapshot.rotationValueZ;
                    }
                    snapshot.isCurrentlyRunningRotationAnimation = true;
                }
                AnimationPoint pXPoint = (AnimationPoint)boneAnimation.positionXQueue().poll();
                AnimationPoint pYPoint = (AnimationPoint)boneAnimation.positionYQueue().poll();
                AnimationPoint pZPoint = (AnimationPoint)boneAnimation.positionZQueue().poll();
                if (pXPoint != null && pYPoint != null && pZPoint != null) {
                    snapshot.positionOffsetX = MathUtil.lerpValues(pXPoint, controller.easingType, (Function<Double, Double>)controller.customEasingMethod);
                    snapshot.positionOffsetY = MathUtil.lerpValues(pYPoint, controller.easingType, (Function<Double, Double>)controller.customEasingMethod);
                    snapshot.positionOffsetZ = MathUtil.lerpValues(pZPoint, controller.easingType, (Function<Double, Double>)controller.customEasingMethod);
                    snapshot.isCurrentlyRunningPositionAnimation = true;
                }
                AnimationPoint sXPoint = (AnimationPoint)boneAnimation.scaleXQueue().poll();
                AnimationPoint sYPoint = (AnimationPoint)boneAnimation.scaleYQueue().poll();
                AnimationPoint sZPoint = (AnimationPoint)boneAnimation.scaleZQueue().poll();
                if (sXPoint == null || sYPoint == null || sZPoint == null) continue;
                snapshot.scaleValueX = MathUtil.lerpValues(sXPoint, controller.easingType, (Function<Double, Double>)controller.customEasingMethod);
                snapshot.scaleValueY = MathUtil.lerpValues(sYPoint, controller.easingType, (Function<Double, Double>)controller.customEasingMethod);
                snapshot.scaleValueZ = MathUtil.lerpValues(sZPoint, controller.easingType, (Function<Double, Double>)controller.customEasingMethod);
                snapshot.isCurrentlyRunningScaleAnimation = true;
            }
        }
        this.modelDirty = false;
        this.reloadAnimations = false;
        double resetTickLength = manager.getResetSpeed();
        for (BoneTopLevelSnapshot topLevelSnapshot : this.boneMap.values()) {
            double percentageReset;
            BoneSnapshot initialSnapshot = topLevelSnapshot.bone.getInitialSnapshot();
            if (!topLevelSnapshot.isCurrentlyRunningRotationAnimation) {
                percentageReset = Math.min((seekTime - (double)topLevelSnapshot.mostRecentResetRotationTick) / resetTickLength, 1.0);
                if (percentageReset >= 1.0) {
                    topLevelSnapshot.rotationValueX = MathUtil.lerpValues(percentageReset, topLevelSnapshot.rotationValueX, initialSnapshot.rotationValueX);
                    topLevelSnapshot.rotationValueY = MathUtil.lerpValues(percentageReset, topLevelSnapshot.rotationValueY, initialSnapshot.rotationValueY);
                    topLevelSnapshot.rotationValueZ = MathUtil.lerpValues(percentageReset, topLevelSnapshot.rotationValueZ, initialSnapshot.rotationValueZ);
                }
            } else {
                topLevelSnapshot.mostRecentResetRotationTick = 0.0f;
                topLevelSnapshot.isCurrentlyRunningRotationAnimation = false;
            }
            if (!topLevelSnapshot.isCurrentlyRunningPositionAnimation) {
                percentageReset = Math.min((seekTime - (double)topLevelSnapshot.mostRecentResetPositionTick) / resetTickLength, 1.0);
                if (percentageReset >= 1.0) {
                    topLevelSnapshot.positionOffsetX = MathUtil.lerpValues(percentageReset, topLevelSnapshot.positionOffsetX, initialSnapshot.positionOffsetX);
                    topLevelSnapshot.positionOffsetY = MathUtil.lerpValues(percentageReset, topLevelSnapshot.positionOffsetY, initialSnapshot.positionOffsetY);
                    topLevelSnapshot.positionOffsetZ = MathUtil.lerpValues(percentageReset, topLevelSnapshot.positionOffsetZ, initialSnapshot.positionOffsetZ);
                }
            } else {
                topLevelSnapshot.mostRecentResetPositionTick = (float)seekTime;
                topLevelSnapshot.isCurrentlyRunningPositionAnimation = false;
            }
            if (!topLevelSnapshot.isCurrentlyRunningScaleAnimation) {
                percentageReset = Math.min((seekTime - (double)topLevelSnapshot.mostRecentResetScaleTick) / resetTickLength, 1.0);
                if (percentageReset >= 1.0) {
                    topLevelSnapshot.scaleValueX = MathUtil.lerpValues(percentageReset, topLevelSnapshot.scaleValueX, initialSnapshot.scaleValueX);
                    topLevelSnapshot.scaleValueY = MathUtil.lerpValues(percentageReset, topLevelSnapshot.scaleValueY, initialSnapshot.scaleValueY);
                    topLevelSnapshot.scaleValueZ = MathUtil.lerpValues(percentageReset, topLevelSnapshot.scaleValueZ, initialSnapshot.scaleValueZ);
                }
            } else {
                topLevelSnapshot.mostRecentResetScaleTick = (float)seekTime;
                topLevelSnapshot.isCurrentlyRunningScaleAnimation = false;
            }
            topLevelSnapshot.commit();
        }
        manager.isFirstTick = false;
    }

    public void updateModel(Collection<IBone> bones) {
        this.boneMap.clear();
        for (IBone bone : bones) {
            this.boneMap.put(bone.getName(), new BoneTopLevelSnapshot(bone));
        }
        this.modelDirty = true;
    }

    public boolean isModelEmpty() {
        return this.boneMap.isEmpty();
    }

    public void preAnimationSetup(double seekTime) {
        ((AnimatableEntity)this.animatable).setMolangQueries(seekTime);
    }
}

