/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.misc;

import com.github.tartaricacid.touhoulittlemaid.entity.item.AbstractEntityFromItem;
import com.github.tartaricacid.touhoulittlemaid.entity.misc.MonsterType;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemMonsterList;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public final class DefaultMonsterType {
    private static final Map<EntityType<?>, MonsterType> DEFAULT = Maps.newHashMap();

    public static void initDefault(Level level) {
        if (!DEFAULT.isEmpty()) {
            return;
        }
        ForgeRegistries.ENTITY_TYPES.getValues().forEach(type -> {
            Entity entity = null;
            try {
                entity = type.m_20615_(level);
            }
            catch (Exception e) {
                e.fillInStackTrace();
            }
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity instanceof ArmorStand || livingEntity instanceof AbstractEntityFromItem || livingEntity instanceof Player) {
                return;
            }
            if (livingEntity instanceof Enemy) {
                DEFAULT.putIfAbsent((EntityType<?>)type, MonsterType.HOSTILE);
                return;
            }
            if (livingEntity instanceof TamableAnimal || livingEntity instanceof Npc) {
                DEFAULT.putIfAbsent((EntityType<?>)type, MonsterType.FRIENDLY);
                return;
            }
            DEFAULT.putIfAbsent((EntityType<?>)type, MonsterType.NEUTRAL);
        });
    }

    public static Map<EntityType<?>, MonsterType> getMonsterList(ItemStack stack, @Nullable Level level) {
        HashMap output = Maps.newHashMap();
        if (level == null || stack.m_41720_() != InitItems.MONSTER_LIST.get()) {
            return output;
        }
        CompoundTag monsterList = ItemMonsterList.getMonsterList(stack);
        monsterList.m_128431_().forEach(key -> DefaultMonsterType.readTagData(key, monsterList, output));
        DEFAULT.forEach(output::putIfAbsent);
        return output;
    }

    public static MonsterType getMonsterType(EntityType<?> entityType) {
        return DEFAULT.getOrDefault(entityType, MonsterType.NEUTRAL);
    }

    public static boolean canAttack(EntityMaid maid, LivingEntity target, MonsterType monsterType) {
        if (monsterType == MonsterType.FRIENDLY) {
            return false;
        }
        if (monsterType == MonsterType.NEUTRAL) {
            return DefaultMonsterType.checkNeutral(maid, target);
        }
        return true;
    }

    private static void readTagData(String key, CompoundTag monsterList, Map<EntityType<?>, MonsterType> output) {
        int index = monsterList.m_128451_(key);
        MonsterType monsterType = MonsterType.getTypeByIndex(index);
        ResourceLocation id = new ResourceLocation(key);
        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(id);
        if (entityType != null) {
            output.put(entityType, monsterType);
        }
    }

    private static boolean checkNeutral(EntityMaid maid, LivingEntity target) {
        LivingEntity livingEntity = maid.m_269323_();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            LivingEntity lastHurtByMob = player.m_21188_();
            if (target.equals((Object)lastHurtByMob)) {
                return true;
            }
            LivingEntity lastHurtMob = player.m_21214_();
            if (target.equals((Object)lastHurtMob)) {
                return true;
            }
        }
        LivingEntity maidLastHurtByMob = maid.m_21188_();
        return target.equals((Object)maidLastHurtByMob);
    }
}

