/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.github.tartaricacid.touhoulittlemaid.capability.PowerCapabilityProvider;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.BeaconAbsorbMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class EntityPowerPoint
extends Entity
implements IEntityAdditionalSpawnData {
    public static final EntityType<EntityPowerPoint> TYPE = EntityType.Builder.m_20704_(EntityPowerPoint::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(6).m_20717_(20).m_20712_("power_point");
    private static final int MAX_AGE = 6000;
    public int tickCount;
    public int age;
    public int throwTime;
    public int value;
    private int health = 5;
    private Player followingPlayer;
    private int followingTime;

    public EntityPowerPoint(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public EntityPowerPoint(Level worldIn, double x, double y, double z, int powerValue) {
        this(TYPE, worldIn);
        this.m_6034_(x, y, z);
        this.m_146922_((float)(this.f_19796_.m_188500_() * 360.0));
        this.m_20334_((this.f_19796_.m_188500_() * 0.2 - 0.1) * 2.0, this.f_19796_.m_188500_() * 0.2 * 2.0, (this.f_19796_.m_188500_() * 0.2 - 0.1) * 2.0);
        this.value = powerValue;
    }

    public static int getPowerValue(int powerValue) {
        if (powerValue >= 485) {
            return 485;
        }
        if (powerValue >= 385) {
            return 385;
        }
        if (powerValue >= 285) {
            return 285;
        }
        if (powerValue >= 185) {
            return 185;
        }
        if (powerValue >= 89) {
            return 89;
        }
        if (powerValue >= 36) {
            return 34;
        }
        if (powerValue >= 17) {
            return 13;
        }
        if (powerValue >= 7) {
            return 7;
        }
        if (powerValue >= 5) {
            return 5;
        }
        return powerValue >= 3 ? 3 : 1;
    }

    public static int transPowerValueToXpValue(int powerValue) {
        return powerValue / 4;
    }

    public static void spawnExplosionParticle(Level world, float x, float y, float z, RandomSource rand) {
        if (!world.f_46443_) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            float mx = (rand.m_188501_() - 0.5f) * 0.02f;
            float my = (rand.m_188501_() - 0.5f) * 0.02f;
            float mz = (rand.m_188501_() - 0.5f) * 0.02f;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123796_, (double)(x + rand.m_188501_() - 0.5f), (double)(y + rand.m_188501_() - 0.5f), (double)(z + rand.m_188501_() - 0.5f), (double)mx, (double)my, (double)mz);
        }
    }

    public void spawnExplosionParticle() {
        float x = (float)this.m_20182_().f_82479_;
        float y = (float)this.m_20182_().f_82480_ + 0.125f;
        float z = (float)this.m_20182_().f_82481_;
        if (this.f_19853_.f_46443_) {
            EntityPowerPoint.spawnExplosionParticle(this.f_19853_, x, y, z, this.f_19796_);
        } else {
            NetworkHandler.sendToNearby(this.f_19853_, this.m_20183_(), new BeaconAbsorbMessage(x, y, z));
        }
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.throwTime > 0) {
            --this.throwTime;
        }
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        this.fluidMovement();
        if (!this.f_19853_.m_45772_(this.m_20191_())) {
            this.m_20314_(this.m_20185_(), (this.m_20191_().f_82289_ + this.m_20191_().f_82292_) / 2.0, this.m_20189_());
        }
        this.followingMovement();
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.groundMovement();
        ++this.tickCount;
        ++this.age;
        if (this.age >= 6000) {
            this.m_146870_();
        }
    }

    private void groundMovement() {
        double slipperiness = 0.98;
        if (this.m_20096_()) {
            BlockPos pos = new BlockPos((int)this.m_20185_(), (int)(this.m_20186_() - 1.0), (int)this.m_20189_());
            slipperiness = (double)this.f_19853_.m_8055_(pos).getFriction((LevelReader)this.f_19853_, pos, (Entity)this) * 0.98;
        }
        this.m_20256_(this.m_20184_().m_82542_(slipperiness, 0.98, slipperiness));
        if (this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, -0.9, 1.0));
        }
    }

    private void followingMovement() {
        Vec3 relativeVector;
        double length;
        double distance = 8.0;
        if (this.followingTime < this.getRandomCheckTime()) {
            if (this.followingPlayer == null || (double)this.followingPlayer.m_20270_((Entity)this) > distance) {
                this.followingPlayer = this.f_19853_.m_45930_((Entity)this, distance);
            }
            this.followingTime = this.tickCount;
        }
        if (this.followingPlayer != null && this.followingPlayer.m_5833_()) {
            this.followingPlayer = null;
        }
        if (this.followingPlayer != null && (length = (relativeVector = new Vec3(this.followingPlayer.m_20185_() - this.m_20185_(), this.followingPlayer.m_20186_() + (double)this.followingPlayer.m_20192_() / 2.0 - this.m_20186_(), this.followingPlayer.m_20189_() - this.m_20189_())).m_82553_()) < distance) {
            double factor = 1.0 - length / 8.0;
            this.m_20256_(this.m_20184_().m_82549_(relativeVector.m_82541_().m_82490_(factor * factor * 0.1)));
        }
    }

    private int getRandomCheckTime() {
        return this.tickCount - 20 + this.m_19879_() % 100;
    }

    private void fluidMovement() {
        if (this.m_204029_(FluidTags.f_13131_)) {
            Vec3 movement = this.m_20184_();
            this.m_20334_(movement.f_82479_ * 0.99, Math.min(movement.f_82480_ + 5.0E-4, 0.06), movement.f_82481_ * 0.99);
        } else if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.03, 0.0));
        }
        if (this.f_19853_.m_6425_(this.m_20183_()).m_205070_(FluidTags.f_13132_)) {
            this.m_20334_((this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.2, 0.2, (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.2);
            this.m_5496_(SoundEvents.f_11909_, 0.4f, 2.0f + this.f_19796_.m_188501_() * 0.4f);
        }
    }

    protected void m_5841_() {
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.f_19853_.f_46443_ || !this.m_6084_()) {
            return false;
        }
        if (!this.m_6673_(source)) {
            this.m_5834_();
            this.health = (int)((float)this.health - amount);
            if (this.health <= 0) {
                this.m_146870_();
            }
        }
        return false;
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128376_("Health", (short)this.health);
        compound.m_128376_("Age", (short)this.age);
        compound.m_128376_("Value", (short)this.value);
    }

    public void m_7378_(CompoundTag compound) {
        this.health = compound.m_128448_("Health");
        this.age = compound.m_128448_("Age");
        this.value = compound.m_128448_("Value");
    }

    public void m_6123_(Player player) {
        if (this.f_19853_.f_46443_) {
            return;
        }
        if (this.throwTime == 0 && player.f_36101_ == 0) {
            LazyOptional powerCap = player.getCapability(PowerCapabilityProvider.POWER_CAP, null);
            powerCap.ifPresent(power -> {
                player.f_36101_ = 2;
                this.take((Entity)player, 1);
                if (this.value > 0) {
                    if (power.get() + (float)this.value / 100.0f > 5.0f) {
                        power.add(5.0f - power.get());
                        int residualValue = this.value - 500 + (int)(power.get() * 100.0f);
                        player.m_6756_(EntityPowerPoint.transPowerValueToXpValue(residualValue));
                    } else {
                        power.add((float)this.value / 100.0f);
                    }
                }
                this.m_146870_();
            });
        }
    }

    public void take(Entity player, int quantity) {
        if (this.m_6084_() && !this.f_19853_.f_46443_) {
            ((ServerLevel)this.f_19853_).m_7726_().m_8445_((Entity)this, (Packet)new ClientboundTakeItemEntityPacket(this.m_19879_(), player.m_19879_(), quantity));
        }
    }

    public int getValue() {
        return this.value;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getIcon() {
        if (this.value >= 485) {
            return 10;
        }
        if (this.value >= 385) {
            return 9;
        }
        if (this.value >= 285) {
            return 8;
        }
        if (this.value >= 185) {
            return 7;
        }
        if (this.value >= 89) {
            return 6;
        }
        if (this.value >= 36) {
            return 5;
        }
        if (this.value >= 17) {
            return 4;
        }
        if (this.value >= 7) {
            return 3;
        }
        if (this.value >= 5) {
            return 2;
        }
        return this.value >= 3 ? 1 : 0;
    }

    public boolean m_6097_() {
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.value);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.value = additionalData.readInt();
    }
}

